/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.apigateway.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.model.messageflow.MuleConfiguration;

public class ReplaceListenerConfigDialog
extends TitleAreaDialog {
    private MuleConfiguration muleConfiguration;
    private boolean replaceExistingHttpConfig;

    public ReplaceListenerConfigDialog(Shell parentShell, MuleConfiguration muleConfiguration) {
        super(parentShell);
        this.muleConfiguration = muleConfiguration;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Port conflict with API Gateway domain detected");
    }

    public Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        this.setTitle("Port conflict with API Gateway domain detected");
        this.setMessage("The listener configuration from the " + this.muleConfiguration.getName() + " Mule configuration can be replaced by the one in the API Gateway domain.");
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)composite);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText("API Gateway runtimes come pre-configured with a default domain which offers a shared port for all applications deployed in the API Gateway runtime.\nThis project has been associated with this runtime and domain, but it has an HTTP listener which uses that same port. When deployed, it will conflict.\nWould you like to remove the listener configuration from the " + this.muleConfiguration.getName() + " Mule configuration and use the one in the shared domain instead?");
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)descriptionLabel);
        Button replaceListenerConfigButton = new Button(composite, 32);
        replaceListenerConfigButton.setText("Replace existing HTTP listener configuration.");
        replaceListenerConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                ReplaceListenerConfigDialog.this.setReplaceExistingHttpConfig(button.getSelection());
            }
        });
        replaceListenerConfigButton.setSelection(true);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)replaceListenerConfigButton);
        this.replaceExistingHttpConfig = true;
        return composite;
    }

    public boolean isReplaceExistingHttpConfig() {
        return this.replaceExistingHttpConfig;
    }

    public void setReplaceExistingHttpConfig(boolean replaceExistingHttpConfig) {
        this.replaceExistingHttpConfig = replaceExistingHttpConfig;
    }
}

