/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.apigateway.client;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.mule.tooling.ui.contribution.apigateway.client.RestClientException;
import org.mule.tooling.ui.contribution.apigateway.client.UnauthorizedException;

public abstract class OAuth2Filter
implements ClientRequestFilter,
ClientResponseFilter {
    private String accessToken;
    private ReadWriteLock accessTokenLock = new ReentrantReadWriteLock();

    protected OAuth2Filter(URI loginUrl) {
    }

    public void filter(ClientRequestContext request) throws IOException {
        try {
            this.accessTokenLock.writeLock().lock();
            if (this.accessToken == null) {
                this.accessToken = this.authenticate(request);
            }
        }
        finally {
            this.accessTokenLock.writeLock().unlock();
        }
        this.accessTokenLock.readLock().lock();
        String accessTokenInUse = this.accessToken;
        request.setProperty("accessTokenInUse", (Object)this.accessToken);
        this.accessTokenLock.readLock().unlock();
        if (request.getHeaders().containsKey((Object)"Authorization")) {
            request.getHeaders().remove((Object)"Authorization");
        }
        request.getHeaders().add((Object)"Authorization", (Object)("Bearer " + accessTokenInUse));
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext response) throws IOException {
        if (response.getStatus() == 403) {
            try {
                this.accessTokenLock.writeLock().lock();
                String accessTokenInUse = (String)requestContext.getProperty("accessTokenInUse");
                if (accessTokenInUse != null && accessTokenInUse.equals(this.accessToken)) {
                    this.accessToken = null;
                }
            }
            finally {
                this.accessTokenLock.writeLock().unlock();
            }
        }
    }

    public void reset() {
        this.accessTokenLock.writeLock().lock();
        try {
            this.accessToken = null;
        }
        finally {
            this.accessTokenLock.writeLock().unlock();
        }
    }

    public abstract String authenticate(ClientRequestContext var1) throws UnauthorizedException, RestClientException;
}

