/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.apigateway.client;

import com.google.gson.Gson;
import java.net.URI;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.mule.tooling.ui.contribution.apigateway.client.Authentication;
import org.mule.tooling.ui.contribution.apigateway.client.OAuth2Filter;
import org.mule.tooling.ui.contribution.apigateway.client.RestClientException;
import org.mule.tooling.ui.contribution.apigateway.client.UnauthorizedException;

public class OAuth2ClientCredentialsFilter
extends OAuth2Filter {
    private final URI tokenUrl;
    private final String clientId;
    private final String clientSecret;
    private Gson gson;

    public OAuth2ClientCredentialsFilter(URI tokenUrl, URI loginUrl, String clientId, String clientSecret) {
        super(loginUrl);
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.gson = new Gson();
    }

    @Override
    public String authenticate(ClientRequestContext handler) throws UnauthorizedException, RestClientException {
        Form data = new Form();
        data.param("grant_type", "client_credentials");
        data.param("client_id", this.clientId);
        data.param("client_secret", this.clientSecret);
        Response response = ClientBuilder.newClient().target(this.tokenUrl).request().post(Entity.form((Form)data));
        if (response.getStatus() != 200) {
            throw new UnauthorizedException("Authorization request to Anypoint Platform was not successful, client_id and/or client_secret may be wrong.", (String)response.readEntity(String.class));
        }
        Authentication auth = (Authentication)this.gson.fromJson((String)response.readEntity(String.class), Authentication.class);
        return auth.getAccessToken();
    }
}

