/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.apigateway.client;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.mule.tooling.ui.contribution.apigateway.client.Me;
import org.mule.tooling.ui.contribution.apigateway.client.OAuth2ClientCredentialsFilter;
import org.mule.tooling.ui.contribution.apigateway.client.RestClientException;
import org.mule.tooling.ui.contribution.apigateway.client.UnauthorizedException;

public class APIPlatformRestClient {
    private static final int readTimeout = 10000;
    private static final int connectTimeout = 10000;
    private static final String auth_resource = "accounts/oauth2/token";
    private static final String login_resource = "login";
    private static final String me_resource = "accounts/api/me";
    private String portalBaseUri;
    private Client restClient;
    private OAuth2ClientCredentialsFilter oauth2Filter;
    private Gson gson;

    public APIPlatformRestClient(String platformBaseUri, String analyticsBaseUri, String clientId, String clientSecret) throws UnauthorizedException, IOException, RestClientException, URISyntaxException {
        this.setup(platformBaseUri, analyticsBaseUri, clientId, clientSecret);
    }

    private void setup(String platformBaseUri, String analyticsBaseUri, String clientId, String clientSecret) throws URISyntaxException {
        this.gson = new Gson();
        if (!((String)platformBaseUri).endsWith("/")) {
            platformBaseUri = (String)platformBaseUri + "/";
        }
        this.portalBaseUri = platformBaseUri;
        this.restClient = ClientBuilder.newClient();
        this.oauth2Filter = new OAuth2ClientCredentialsFilter(new URI(this.portalBaseUri + auth_resource), new URI(this.portalBaseUri + login_resource), clientId, clientSecret);
        this.restClient.register((Object)this.oauth2Filter);
        this.restClient.property("jersey.config.client.readTimeout", (Object)10000);
        this.restClient.property("jersey.config.client.connectTimeout", (Object)10000);
    }

    public Me me() throws IOException, UnauthorizedException, RestClientException {
        String stringMe = (String)this.restClient.target(this.portalBaseUri).path(me_resource).request().get(String.class);
        Me me = (Me)this.gson.fromJson(stringMe, Me.class);
        return me;
    }
}

