/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.contextual.documentation;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.tooling.ui.modules.core.contextualhelp.DocumentationDescriptor;
import org.mule.tooling.ui.modules.core.contextualhelp.LinkDescriptor;

public class DocumentationDescriptorDeserializer {
    private static final String READING_JSON_LINK_FILE_ERROR_MSG = "There was a problem while reading the file";
    private static Gson gson = new Gson();

    public List<DocumentationDescriptor> deserialize(InputStream inputStream) throws IOException {
        Type DocumentationDescriptorType = new TypeToken<List<DocumentationDescriptor>>(){}.getType();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            List parsedJson = (List)gson.fromJson((Reader)bufferedReader, DocumentationDescriptorType);
            if (parsedJson != null) {
                return this.getOnlyValidDocumentDescriptor(parsedJson);
            }
            throw new IOException(READING_JSON_LINK_FILE_ERROR_MSG);
        }
        catch (JsonIOException | JsonSyntaxException throwable) {
            throw new IOException(READING_JSON_LINK_FILE_ERROR_MSG);
        }
    }

    private List<DocumentationDescriptor> getOnlyValidDocumentDescriptor(List<DocumentationDescriptor> descriptors) {
        return descriptors.stream().filter(documentationDescriptor -> this.isValid((DocumentationDescriptor)documentationDescriptor)).collect(Collectors.toList());
    }

    private boolean isValid(DocumentationDescriptor documentationDescriptor) {
        List links = documentationDescriptor.getLinks();
        if (documentationDescriptor.getId() != null && links != null) {
            Optional<LinkDescriptor> anyLink = links.stream().filter(linkDescriptor -> linkDescriptor.getLink() != null).findAny();
            return anyLink.isPresent();
        }
        return false;
    }
}

