/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.contextual.documentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.contextual.documentation.DocumentationDescriptorDeserializer;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.modules.core.contextualhelp.DocumentationDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String JSON = ".json";
    private static final String BUNDLE_ID = "org.mule.tooling.contextual.documentation";
    private static Map<String, DocumentationDescriptor> definitionIdsToDocumentationDescriptors;

    public void start(BundleContext context) throws Exception {
        definitionIdsToDocumentationDescriptors = new HashMap<String, DocumentationDescriptor>();
        this.retrieveDocumentationDescriptors();
    }

    public void stop(BundleContext context) throws Exception {
    }

    private void retrieveDocumentationDescriptors() {
        Bundle bundle = Platform.getBundle((String)BUNDLE_ID);
        Enumeration filePaths = bundle.getEntryPaths("/resources");
        while (filePaths != null && filePaths.hasMoreElements()) {
            this.readFileAndGenerateLinks((String)filePaths.nextElement());
        }
    }

    private void readFileAndGenerateLinks(String filePath) {
        if (filePath.toLowerCase().endsWith(JSON)) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filePath);){
                    if (inputStream != null) {
                        DocumentationDescriptorDeserializer documentationDescriptorDeserializer = new DocumentationDescriptorDeserializer();
                        documentationDescriptorDeserializer.deserialize(inputStream).forEach(documentationDescriptor -> definitionIdsToDocumentationDescriptors.put(documentationDescriptor.getId(), (DocumentationDescriptor)documentationDescriptor));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                MuleCorePlugin.logWarning((String)(e.getMessage() + " " + filePath));
            }
        }
    }

    public static DocumentationDescriptor getDocumentationDescriptor(String nodeDefinitionId) {
        return definitionIdsToDocumentationDescriptors.get(nodeDefinitionId);
    }

    public static Collection<DocumentationDescriptor> getDocumentationDescriptors() {
        return definitionIdsToDocumentationDescriptors.values();
    }
}

