/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.model.connection.oauth;

import com.mulesoft.connectivity.mule.persistence.model.connection.HttpAuthenticationType;
import java.util.List;

public class OAuth2AuthenticationType
extends HttpAuthenticationType {
    private final Placement placement;
    private final String refreshUrl;
    private final List<String> scopes;

    protected OAuth2AuthenticationType(GrantType grantType, Placement placement, String refreshUrl, List<String> scopes) {
        super(HttpAuthenticationType.Type.oauth2, String.valueOf((Object)grantType));
        this.placement = placement;
        this.refreshUrl = refreshUrl;
        this.scopes = scopes;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public static enum Placement {
        body,
        basicAuth;


        public static Placement fromString(String value) {
            return switch (value == null ? "body" : value) {
                case "body" -> body;
                case "basicAuth" -> basicAuth;
                default -> throw new IllegalArgumentException("Unsupported placement of Credentials for OAuth: " + value);
            };
        }
    }

    public static enum GrantType {
        authorizationCode,
        clientCredentials;


        public static GrantType fromString(String value) {
            return switch (value) {
                case "authorizationCode" -> authorizationCode;
                case "clientCredentials" -> clientCredentials;
                default -> throw new IllegalArgumentException("Unsupported GrantType: " + value);
            };
        }
    }
}

