/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.exchange;

import com.google.common.base.Preconditions;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import java.util.List;
import org.mule.tools.client.authentication.model.Credentials;

public class ExchangeRepositoryMetadata {
    private String baseUri;
    private String organizationId;
    private Credentials credentials;
    private ExchangeUriChecker exchangeUriChecker;

    public ExchangeRepositoryMetadata() {
        this.exchangeUriChecker = new ExchangeUriChecker();
    }

    public ExchangeRepositoryMetadata(Credentials credentials, String uri, List<String> customDomains) {
        this.credentials = credentials;
        this.exchangeUriChecker = new ExchangeUriChecker(customDomains);
        this.parseUri(uri);
    }

    private void parseUri(String uri) {
        this.baseUri = this.getBaseUri(uri);
        this.organizationId = this.getOrganizationId(uri);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    protected String getBaseUri(String uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"URI should not be null");
        String baseUri = this.exchangeUriChecker.extractBaseAnypointUriFromMavenRepositoryUri(uri);
        if (baseUri == null) {
            throw new IllegalArgumentException("The URI " + uri + " is not a valid URI to Exchange");
        }
        return baseUri;
    }

    protected String getOrganizationId(String uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"URI should not be null");
        String organizationId = this.exchangeUriChecker.extractOrganizationIdFromExchangeRepositoryUri(uri);
        if (organizationId == null) {
            throw new IllegalArgumentException("The URI " + uri + " is not a valid URI to Exchange");
        }
        return organizationId;
    }
}

