/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.mule.tools.api.util.JarExplorer;
import org.mule.tools.api.util.JarInfo;

public class FileJarExplorer
implements JarExplorer {
    protected static final String CLASS_EXTENSION = ".class";
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(File.separator));

    @Override
    public JarInfo explore(URI library) {
        TreeSet<String> resources;
        TreeSet<String> packages;
        block14: {
            packages = new TreeSet<String>();
            resources = new TreeSet<String>();
            try {
                File libraryFile = new File(library);
                if (!libraryFile.exists()) {
                    throw new IllegalArgumentException("Library file does not exists: " + library);
                }
                if (libraryFile.isDirectory()) {
                    Collection files = FileUtils.listFiles((File)libraryFile, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.INSTANCE);
                    for (File classFile : files) {
                        String relativePath = classFile.getAbsolutePath().substring(libraryFile.getAbsolutePath().length() + 1);
                        if (relativePath.indexOf(File.separatorChar) > 0 && relativePath.endsWith(CLASS_EXTENSION)) {
                            packages.add(SEPARATOR_PATTERN.matcher(relativePath.substring(0, relativePath.lastIndexOf(File.separatorChar))).replaceAll("."));
                            continue;
                        }
                        if (File.separatorChar == '/') {
                            resources.add(relativePath);
                            continue;
                        }
                        resources.add(SEPARATOR_PATTERN.matcher(relativePath).replaceAll("/"));
                    }
                    break block14;
                }
                if (!libraryFile.getName().toLowerCase().endsWith(".jar")) break block14;
                try (ZipFile zipFile = new ZipFile(libraryFile);){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (entry.isDirectory()) continue;
                        if (name.endsWith(CLASS_EXTENSION)) {
                            if (name.lastIndexOf(47) < 0) continue;
                            packages.add(SLASH_PATTERN.matcher(name.substring(0, name.lastIndexOf(47))).replaceAll("."));
                            continue;
                        }
                        resources.add(name);
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot explore URL: " + library, e);
            }
        }
        return new JarInfo(packages, resources);
    }
}

