/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tooling;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.exception.AgentApplicationConfigurationException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.RuntimeVersionService;
import com.mulesoft.agent.services.ToolingService;
import com.mulesoft.agent.services.injector.SchedulerServiceAware;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.module.tooling.api.ToolingServiceAware;

@Named(value="mule.agent.tooling.service")
@Singleton
public class MuleAgentToolingService
extends ConfigurableAgentService
implements ToolingService,
ToolingServiceAware,
SchedulerServiceAware {
    public static final int DEFAULT_EXPIRE_MINUTES = 10;
    private static final Logger LOGGER = LogManager.getLogger(MuleAgentToolingService.class);
    static final String TOOLING_TRACKING_ID = "_toolingTrackingId";
    private org.mule.runtime.module.tooling.api.ToolingService toolingService;
    private Cache<String, Domain> deployedDomains;
    private Cache<String, Application> deployedApplications;
    private Optional<Ticker> ticker = Optional.empty();
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    @Configurable(value="10", type=Type.DYNAMIC)
    private int expireAfterAccessApplicationsThreshold = 10;
    @Configurable(value="MINUTES", type=Type.DYNAMIC)
    private String expireAfterAccessApplicationsTimeUnit = TimeUnit.MINUTES.name();
    @Inject
    private RuntimeVersionService runtimeVersionService;

    protected void doStart() throws MuleException {
        TimeUnit timeUnit;
        try {
            timeUnit = TimeUnit.valueOf(this.expireAfterAccessApplicationsTimeUnit);
        }
        catch (IllegalArgumentException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Cache expireAfterAccess time unit is invalid, only supported SECONDS or MINUTES"));
        }
        if (!timeUnit.equals((Object)TimeUnit.SECONDS) && !timeUnit.equals((Object)TimeUnit.MINUTES)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Cache expireAfterAccess should be defined in SECONDS or MINUTES only, %s is not supported", new Object[]{timeUnit})));
        }
        CacheBuilder applicationCacheBuilder = CacheBuilder.newBuilder().removalListener(this.applicationRemovalListener()).expireAfterAccess((long)this.expireAfterAccessApplicationsThreshold, timeUnit);
        this.ticker.ifPresent(ticker -> {
            applicationCacheBuilder.ticker(ticker);
            applicationCacheBuilder.recordStats();
        });
        this.deployedApplications = applicationCacheBuilder.build();
        CacheBuilder domainCacheBuilder = CacheBuilder.newBuilder().removalListener(this.domainRemovalListener()).expireAfterAccess((long)this.expireAfterAccessApplicationsThreshold, timeUnit);
        this.ticker.ifPresent(ticker -> {
            domainCacheBuilder.ticker(ticker);
            domainCacheBuilder.recordStats();
        });
        this.deployedDomains = domainCacheBuilder.build();
        this.scheduler = this.schedulerService.customScheduler(SchedulerConfig.config().withName("ToolingServiceArtifactExpiration").withPrefix("MuleAgent").withShutdownTimeout(100L, TimeUnit.MILLISECONDS).withMaxConcurrentTasks(1));
        long period = 1L;
        if (this.expireAfterAccessApplicationsThreshold > 1) {
            period = this.expireAfterAccessApplicationsThreshold / 2;
        }
        this.scheduler.scheduleWithFixedDelay(() -> {
            this.deployedApplications.cleanUp();
            this.deployedDomains.cleanUp();
        }, period, period, timeUnit);
    }

    private RemovalListener<String, Application> applicationRemovalListener() {
        return notification -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Disposing application '" + ((Application)notification.getValue()).getArtifactName() + "' for artifactId: " + (String)notification.getKey());
            }
            this.disposeDeployableArtifactQuietly((String)notification.getKey(), (DeployableArtifact)notification.getValue());
        };
    }

    private RemovalListener<String, Domain> domainRemovalListener() {
        return notification -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Disposing domain '" + ((Domain)notification.getValue()).getArtifactName() + "' for artifactId: " + (String)notification.getKey());
            }
            this.disposeDeployableArtifactQuietly((String)notification.getKey(), (DeployableArtifact)notification.getValue());
        };
    }

    private void disposeDeployableArtifactQuietly(String artifactId, DeployableArtifact deployableArtifact) {
        try {
            deployableArtifact.dispose();
        }
        catch (Exception e) {
            LOGGER.warn("Error while disposing artifactId: " + artifactId);
        }
    }

    protected void doStop() throws MuleException {
        if (this.deployedApplications != null) {
            this.deployedApplications.invalidateAll();
        }
        if (this.deployedDomains != null) {
            this.deployedDomains.invalidateAll();
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return ImmutableList.of();
    }

    public void setToolingService(org.mule.runtime.module.tooling.api.ToolingService toolingService) {
        this.toolingService = toolingService;
    }

    public void deployToolingApplication(String artifactId, File appFolder, String domainName, Optional<Map<String, String>> deploymentProperties) {
        if (!appFolder.exists()) {
            throw new IllegalArgumentException("Application folder location doesn't exist");
        }
        String domainId = domainName != null ? this.getDeployedDomain(domainName).getArtifactName() : domainName;
        this.deployToolingArtifact(new ApplicationArtifactDeployer(artifactId, appFolder, domainId, deploymentProperties));
    }

    public String deployToolingApplication(File appFolder, String domainName, Optional<Map<String, String>> deploymentProperties) {
        if (!appFolder.exists()) {
            throw new IllegalArgumentException("Application folder location doesn't exist");
        }
        String domainId = domainName != null ? this.getDeployedDomain(domainName).getArtifactName() : domainName;
        return this.deployToolingArtifact(new ApplicationArtifactDeployer(appFolder, domainId, deploymentProperties));
    }

    public void deployToolingDomain(String artifactId, File domainFolder, Optional<Map<String, String>> deploymentProperties) {
        if (!domainFolder.exists()) {
            throw new IllegalArgumentException("Domain folder location doesn't exist");
        }
        this.deployToolingArtifact(new DomainArtifactDeployer(artifactId, domainFolder, deploymentProperties));
    }

    public String deployToolingDomain(File domainFolder, Optional<Map<String, String>> deploymentProperties) {
        if (!domainFolder.exists()) {
            throw new IllegalArgumentException("Domain folder location doesn't exist");
        }
        return this.deployToolingArtifact(new DomainArtifactDeployer(domainFolder, deploymentProperties));
    }

    public void deployToolingApplication(String artifactId, byte[] appContent, String domainName, Optional<Map<String, String>> deploymentProperties) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deploying tooling application");
        }
        String domainId = domainName != null ? this.getDeployedDomain(domainName).getArtifactName() : domainName;
        this.deployToolingArtifact(new ApplicationArtifactDeployer(artifactId, appContent, domainId, deploymentProperties));
    }

    public String deployToolingApplication(byte[] appContent, String domainName, Optional<Map<String, String>> deploymentProperties) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deploying tooling application");
        }
        String domainId = domainName != null ? this.getDeployedDomain(domainName).getArtifactName() : domainName;
        return this.deployToolingArtifact(new ApplicationArtifactDeployer(appContent, domainId, deploymentProperties));
    }

    public void deployToolingDomain(String artifactId, byte[] domainContent, Optional<Map<String, String>> deploymentProperties) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deploying tooling domain");
        }
        this.deployToolingArtifact(new DomainArtifactDeployer(artifactId, domainContent, deploymentProperties));
    }

    public String deployToolingDomain(byte[] domainContent, Optional<Map<String, String>> deploymentProperties) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deploying tooling domain");
        }
        return this.deployToolingArtifact(new DomainArtifactDeployer(domainContent, deploymentProperties));
    }

    public String disposeToolingDomain(String artifactId) {
        this.deployedDomains.invalidate((Object)artifactId);
        return artifactId;
    }

    public String disposeToolingApplication(String artifactId) {
        this.deployedApplications.invalidate((Object)artifactId);
        return artifactId;
    }

    public List<String> listToolingApplications() {
        return Lists.newArrayList(this.deployedApplications.asMap().keySet());
    }

    public List<String> listToolingDomains() {
        return Lists.newArrayList(this.deployedDomains.asMap().keySet());
    }

    private String deployToolingArtifact(ArtifactDeployer artifactDeployer) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deploying tooling artifact: " + artifactDeployer.getDescription());
        }
        try {
            Object deployableArtifact = artifactDeployer.deploy();
            return artifactDeployer.getArtifactId((DeployableArtifact)deployableArtifact);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Failed to deploy tooling artifact: %s. Cause: %s", artifactDeployer.getDescription(), t.getMessage()), t);
        }
    }

    public Application getDeployedApplication(String artifactId) {
        Application application = (Application)this.deployedApplications.getIfPresent((Object)artifactId);
        if (application == null) {
            throw new NoSuchApplicationException("No application deployed for artifactId: " + artifactId);
        }
        Domain domain = application.getDomain();
        if (domain != null) {
            String domainId = domain.getArtifactName();
            this.deployedDomains.getIfPresent((Object)domainId);
        }
        return application;
    }

    @Deprecated
    private DomainDescriptor getDomainDescriptor(Domain muleDomain) {
        try {
            return (DomainDescriptor)muleDomain.getClass().getMethod("getDescriptor", new Class[0]).invoke((Object)muleDomain, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AgentApplicationConfigurationException("There was an error while getting the descriptor of domain " + muleDomain.getArtifactName(), (Throwable)e);
        }
    }

    public Domain getDeployedDomain(String artifactId) {
        Domain domain = (Domain)this.deployedDomains.getIfPresent((Object)artifactId);
        if (domain == null) {
            throw new NoSuchApplicationException("No domain deployed for artifactId: " + artifactId);
        }
        return domain;
    }

    void setExpireAfterAccessApplicationsThreshold(int expireAfterAccessApplicationsThreshold) {
        this.expireAfterAccessApplicationsThreshold = expireAfterAccessApplicationsThreshold;
    }

    void setTicker(Ticker ticker) {
        this.ticker = Optional.ofNullable(ticker);
    }

    CacheStats getApplicationCacheStats() {
        return this.deployedApplications.stats();
    }

    CacheStats getDomainCacheStats() {
        return this.deployedDomains.stats();
    }

    public void setRuntimeVersionService(RuntimeVersionService runtimeVersionService) {
        this.runtimeVersionService = runtimeVersionService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    void setExpireAfterAccessApplicationsTimeUnit(TimeUnit timeUnit) {
        this.expireAfterAccessApplicationsTimeUnit = timeUnit.name();
    }

    class DomainArtifactDeployer
    extends AbstractDeployableDeployer<Domain> {
        public DomainArtifactDeployer(File location, Optional<Map<String, String>> deploymentProperties) {
            super(location, deploymentProperties);
        }

        public DomainArtifactDeployer(String artifactId, File location, Optional<Map<String, String>> deploymentProperties) {
            super(artifactId, location, deploymentProperties);
        }

        public DomainArtifactDeployer(byte[] jarContent, Optional<Map<String, String>> deploymentProperties) {
            super(jarContent, deploymentProperties);
        }

        public DomainArtifactDeployer(String artifactId, byte[] jarContent, Optional<Map<String, String>> deploymentProperties) {
            super(artifactId, jarContent, deploymentProperties);
        }

        @Override
        public String getType() {
            return "domain";
        }

        @Override
        public Domain deploy() throws IOException {
            Domain domain;
            Properties deploymentProperties = this.getDeploymentProperties();
            if (this.artifactId != null) {
                try {
                    deploymentProperties.put(MuleAgentToolingService.TOOLING_TRACKING_ID, this.artifactId);
                    domain = (Domain)MuleAgentToolingService.this.deployedDomains.get((Object)this.artifactId, () -> {
                        Domain deploy = this.doInternalDeploy(deploymentProperties);
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("Tooling artifact created with id: " + deploy.getArtifactName() + " for artifactId: " + this.artifactId);
                        }
                        return deploy;
                    });
                }
                catch (ExecutionException e) {
                    throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Couldn't deploy domain", (Object[])new Object[]{e}));
                }
            } else {
                domain = this.doInternalDeploy(deploymentProperties);
                MuleAgentToolingService.this.deployedDomains.put((Object)domain.getArtifactName(), (Object)domain);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Tooling artifact created with id: " + domain.getArtifactName());
                }
            }
            return domain;
        }

        private Domain doInternalDeploy(Properties deploymentProperties) throws IOException {
            Domain domain = this.location != null ? (MuleAgentToolingService.this.runtimeVersionService.supportsToolingApplicationDeploymentProperties() ? MuleAgentToolingService.this.toolingService.createDomain(this.location, Optional.of(deploymentProperties)) : MuleAgentToolingService.this.toolingService.createDomain(this.location)) : (MuleAgentToolingService.this.runtimeVersionService.supportsToolingApplicationDeploymentProperties() ? MuleAgentToolingService.this.toolingService.createDomain(this.jarContent, Optional.of(deploymentProperties)) : MuleAgentToolingService.this.toolingService.createDomain(this.jarContent));
            return domain;
        }
    }

    class ApplicationArtifactDeployer
    extends AbstractDeployableDeployer<Application> {
        private String domainName;

        public ApplicationArtifactDeployer(File location, String domainName, Optional<Map<String, String>> deploymentProperties) {
            super(location, deploymentProperties);
            this.domainName = domainName;
        }

        public ApplicationArtifactDeployer(String artifactId, File location, String domainName, Optional<Map<String, String>> deploymentProperties) {
            super(artifactId, location, deploymentProperties);
            this.domainName = domainName;
        }

        public ApplicationArtifactDeployer(byte[] jarContent, String domainName, Optional<Map<String, String>> deploymentProperties) {
            super(null, jarContent, deploymentProperties);
            this.domainName = domainName;
        }

        public ApplicationArtifactDeployer(String artifactId, byte[] jarContent, String domainName, Optional<Map<String, String>> deploymentProperties) {
            super(artifactId, jarContent, deploymentProperties);
            this.domainName = domainName;
        }

        @Override
        public Application deploy() throws IOException {
            Application application;
            Properties deploymentProperties = this.getDeploymentProperties();
            if (this.artifactId != null) {
                try {
                    deploymentProperties.put(MuleAgentToolingService.TOOLING_TRACKING_ID, this.artifactId);
                    application = (Application)MuleAgentToolingService.this.deployedApplications.get((Object)this.artifactId, () -> {
                        Application deploy = this.doInternalDeploy(deploymentProperties);
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("Tooling artifact created with id: " + deploy.getArtifactName() + " for artifactId: " + this.artifactId);
                        }
                        return deploy;
                    });
                }
                catch (ExecutionException e) {
                    throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Couldn't deploy application", (Object[])new Object[]{e}));
                }
            } else {
                application = this.doInternalDeploy(deploymentProperties);
                MuleAgentToolingService.this.deployedApplications.put((Object)application.getArtifactName(), (Object)application);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Tooling artifact created with id: " + application.getArtifactName());
                }
            }
            return application;
        }

        private Application doInternalDeploy(Properties deploymentProperties) throws IOException {
            if (this.domainName != null) {
                deploymentProperties.setProperty("_muleToolingDeploymentDomainNameRef", this.domainName);
            }
            Application application = this.location != null ? MuleAgentToolingService.this.toolingService.createApplication(this.location, Optional.of(deploymentProperties)) : MuleAgentToolingService.this.toolingService.createApplication(this.jarContent, Optional.of(deploymentProperties));
            return application;
        }

        @Override
        public String getType() {
            return "application";
        }
    }

    abstract class AbstractDeployableDeployer<T extends DeployableArtifact>
    implements ArtifactDeployer<T> {
        protected String artifactId;
        protected File location;
        protected byte[] jarContent;
        protected Optional<Map<String, String>> deploymentProperties;

        public AbstractDeployableDeployer(String artifactId, File location, Optional<Map<String, String>> deploymentProperties) {
            this.artifactId = artifactId;
            this.location = location;
            this.deploymentProperties = deploymentProperties;
        }

        public AbstractDeployableDeployer(File location, Optional<Map<String, String>> deploymentProperties) {
            this(null, location, deploymentProperties);
        }

        public AbstractDeployableDeployer(String artifactId, byte[] jarContent, Optional<Map<String, String>> deploymentProperties) {
            this.artifactId = artifactId;
            this.jarContent = jarContent;
            this.deploymentProperties = deploymentProperties;
        }

        public AbstractDeployableDeployer(byte[] jarContent, Optional<Map<String, String>> deploymentProperties) {
            this(null, jarContent, deploymentProperties);
        }

        @Override
        public String getArtifactId(DeployableArtifact deployableArtifact) {
            return this.artifactId != null ? this.artifactId : deployableArtifact.getArtifactName();
        }

        @Override
        public String getDescription() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(this.getType());
            if (this.artifactId != null) {
                builder.append("(");
                builder.append(this.artifactId);
                builder.append(")");
            }
            if (this.location != null) {
                builder.append("(");
                builder.append(this.location.getAbsolutePath());
                builder.append(")");
            }
            builder.append("]");
            return builder.toString();
        }

        protected abstract String getType();

        protected Properties getDeploymentProperties() {
            return this.deploymentProperties.map(mapProperties -> {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)mapProperties);
                return properties;
            }).orElse(new Properties());
        }
    }

    private static interface ArtifactDeployer<T extends DeployableArtifact> {
        public String getDescription();

        public T deploy() throws IOException;

        public String getArtifactId(DeployableArtifact var1);
    }
}

