/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tooling;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mulesoft.agent.domain.tooling.BundleDescriptor;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.ConnectivityTestingService;
import com.mulesoft.agent.services.ToolingService;
import java.util.List;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.tooling.api.ToolingServiceAware;
import org.mule.runtime.module.tooling.api.connectivity.ConnectivityTestingServiceBuilder;

@Named(value="mule.agent.tooling.connectivity.testing.service")
@Singleton
public class MuleAgentConnectivityTestingService
extends ConfigurableAgentService
implements ConnectivityTestingService,
ToolingServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(MuleAgentConnectivityTestingService.class);
    @Inject
    private ToolingService toolingService;
    private org.mule.runtime.module.tooling.api.ToolingService muleToolingService;

    public ConnectionValidationResult testConnection(List<BundleDescriptor> dependencies, ArtifactDeclaration artifactDeclaration, String globalName) {
        ConnectivityTestingServiceBuilder builder = this.muleToolingService.newConnectivityTestingServiceBuilder();
        dependencies.forEach(bundle -> {
            ConnectivityTestingServiceBuilder cfr_ignored_0 = (ConnectivityTestingServiceBuilder)builder.addDependency(bundle.getGroupId(), bundle.getArtifactId(), bundle.getVersion(), bundle.getClassifier(), bundle.getType());
        });
        builder.setArtifactDeclaration(artifactDeclaration);
        org.mule.runtime.api.connectivity.ConnectivityTestingService service = (org.mule.runtime.api.connectivity.ConnectivityTestingService)builder.build();
        return service.testConnection(Location.builder().globalName(globalName).build());
    }

    public ConnectionValidationResult testConnection(Application application, String globalName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Doing test connection over globalName: " + globalName + " for application: " + application.getArtifactName());
        }
        return application.getConnectivityTestingService().testConnection(Location.builder().globalName(globalName).build());
    }

    public ConnectionValidationResult testConnection(Domain domain, String globalName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Doing test connection over globalName: " + globalName + " for domain: " + domain.getArtifactName());
        }
        return domain.getConnectivityTestingService().testConnection(Location.builder().globalName(globalName).build());
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return ImmutableList.of();
    }

    public void setMuleAgentToolingService(ToolingService toolingService) {
        this.toolingService = toolingService;
    }

    public void setToolingService(org.mule.runtime.module.tooling.api.ToolingService toolingService) {
        this.muleToolingService = toolingService;
    }
}

