/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.application.listeners;

import com.mulesoft.agent.handlers.InternalMessageHandler;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;

public class ContextNotificationHandler
implements MuleContextNotificationListener<MuleContextNotification> {
    private static final Logger LOGGER = LogManager.getLogger(ContextNotificationHandler.class);
    private final String appName;
    private final List<InternalMessageHandler<MuleContextNotification>> muleContextNotificationHandlers;

    public ContextNotificationHandler(String appName, List<InternalMessageHandler<MuleContextNotification>> muleContextNotificationHandlers) {
        this.appName = appName;
        this.muleContextNotificationHandlers = muleContextNotificationHandlers;
    }

    public void onNotification(MuleContextNotification notification) {
        LOGGER.info("MuleContext notification for app '{}' - Action: {} ({}), Context: {}, Domain: {}", (Object)this.appName, (Object)notification.getActionName(), (Object)notification.getAction(), (Object)(notification.getMuleContext() != null ? notification.getMuleContext().getId() : "null"), (Object)notification.getDomain());
        if (this.muleContextNotificationHandlers == null || this.muleContextNotificationHandlers.isEmpty()) {
            LOGGER.debug("MuleContext notification does not have any handlers");
            return;
        }
        for (InternalMessageHandler<MuleContextNotification> handler : this.muleContextNotificationHandlers) {
            try {
                LOGGER.info("Processing MuleContext notification with handler: {}", (Object)handler.getClass().getSimpleName());
                handler.handle((Object)notification);
            }
            catch (Exception e) {
                LOGGER.error("Error processing MuleContext notification with handler {}: {}", (Object)handler.getClass().getSimpleName(), (Object)e.getMessage());
            }
        }
    }
}

