/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.application;

import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ComponentOperationException;
import com.mulesoft.agent.exception.InvalidConfigurationException;
import com.mulesoft.agent.exception.NoSuchComponentException;
import com.mulesoft.agent.services.AdministrationService;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeploymentConfigurationManager {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentConfigurationManager.class);
    private String applicationName;
    private Optional<Map<String, Map>> configuration;
    private AdministrationService administrationService;
    private Map<String, ApplicationConfiguration> parsedConfiguration = new HashMap<String, ApplicationConfiguration>();

    private DeploymentConfigurationManager() {
    }

    public static DeploymentConfigurationManager create() {
        return new DeploymentConfigurationManager();
    }

    public DeploymentConfigurationManager from(String applicationName, Map<String, Map> configuration) {
        this.applicationName = applicationName;
        this.configuration = Optional.ofNullable(configuration);
        return this;
    }

    public DeploymentConfigurationManager using(AdministrationService administrationService) {
        this.administrationService = administrationService;
        return this;
    }

    public DeploymentConfigurationManager parse() throws NoSuchComponentException, InvalidConfigurationException {
        if (!this.configuration.isPresent()) {
            return this;
        }
        for (Map.Entry<String, Map> entry : this.configuration.get().entrySet()) {
            String componentId = entry.getKey();
            Map applicationConfiguration = entry.getValue();
            try {
                ApplicationConfiguration configuration = this.administrationService.parseApplicationConfiguration(componentId, applicationConfiguration);
                this.parsedConfiguration.put(componentId, configuration);
            }
            catch (NoSuchElementException e) {
                LOGGER.error("Component {} does not exist", (Object)componentId);
                throw new NoSuchComponentException(e.getMessage());
            }
            catch (NoSuchFieldException e) {
                String message = String.format("Component %s does not support deployment configuration", componentId);
                LOGGER.error(message);
                throw new InvalidConfigurationException(message);
            }
        }
        return this;
    }

    public void update() throws NoSuchComponentException, NoSuchFieldException, ComponentOperationException {
        if (!this.configuration.isPresent()) {
            return;
        }
        for (Map.Entry<String, ApplicationConfiguration> entry : this.parsedConfiguration.entrySet()) {
            String componentId = entry.getKey();
            ApplicationConfiguration configuration = entry.getValue();
            LOGGER.info("Parsing config for: " + entry.getKey());
            try {
                this.administrationService.updateApplicationConfiguration(componentId, configuration, this.applicationName);
            }
            catch (NoSuchElementException e) {
                String message = String.format("Invalid reference in configuration for application '%s': Component '%s' does not exist", this.applicationName, componentId);
                LOGGER.warn(message);
                throw new NoSuchComponentException(message);
            }
            catch (NoSuchFieldException e) {
                String message = String.format("Invalid reference in configuration for application '%s': Component '%s' does not allow dynamic application configuration", this.applicationName, componentId);
                LOGGER.warn(message);
                throw new NoSuchFieldException(message);
            }
            catch (AgentEnableOperationException e) {
                LOGGER.error("Unable to update configuration for application: '{}' component: '{}'", (Object)this.applicationName, (Object)entry.getKey(), (Object)e);
            }
        }
    }

    protected String getApplicationName() {
        return this.applicationName;
    }

    protected Optional<Map<String, Map>> getConfiguration() {
        return this.configuration;
    }

    protected AdministrationService getAdministrationService() {
        return this.administrationService;
    }

    protected Map<String, ApplicationConfiguration> getParsedConfiguration() {
        return this.parsedConfiguration;
    }
}

