/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.application;

import com.google.gson.JsonSyntaxException;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ConfigurationLevel;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.domain.deployment.ApplicationMuleDeploymentNotification;
import com.mulesoft.agent.domain.deployment.ArtifactState;
import com.mulesoft.agent.domain.deployment.DeploymentStatus;
import com.mulesoft.agent.domain.flows.FlowStatus;
import com.mulesoft.agent.domain.flows.FlowStatusNotification;
import com.mulesoft.agent.exception.AgentApplicationConfigurationException;
import com.mulesoft.agent.exception.AgentDeploymentException;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ApplicationValidationException;
import com.mulesoft.agent.exception.ComponentOperationException;
import com.mulesoft.agent.exception.ConcurrentDeploymentException;
import com.mulesoft.agent.exception.InvalidConfigurationException;
import com.mulesoft.agent.exception.InvalidFieldException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.exception.NoSuchComponentException;
import com.mulesoft.agent.exception.RuntimeAgentDeploymentException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ApplicationService;
import com.mulesoft.agent.services.ApplicationValidatorService;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.DateService;
import com.mulesoft.agent.services.RuntimeVersionService;
import com.mulesoft.agent.services.application.ApplicationConfiguration;
import com.mulesoft.agent.services.application.DeploymentConfigurationManager;
import com.mulesoft.agent.services.application.FlowConfiguration;
import com.mulesoft.agent.services.application.listeners.ContextNotificationHandler;
import com.mulesoft.agent.services.application.properties.AgentApplicationPropertiesService;
import com.mulesoft.agent.services.scheduling.AgentSchedulingService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.notification.FlowConstructNotification;
import org.mule.runtime.api.notification.FlowConstructNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;

@Named(value="mule.agent.application.service")
@Singleton
public class AgentApplicationService
extends ConfigurableAgentService
implements ApplicationService,
DeploymentServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(AgentApplicationService.class);
    private static final String ARTIFACT_EXTENSION = ".jar";
    @Configurable(type=Type.DYNAMIC, value="[]", level=ConfigurationLevel.APPLICATION)
    private ApplicationConfiguration[] applicationConfigurations;
    private DeploymentService deploymentService;
    private AgentApplicationDeploymentListener deploymentApplicationListener = new AgentApplicationDeploymentListener();
    private Map<String, Date> applicationsLastDateStarted = new ConcurrentHashMap<String, Date>();
    @Inject
    List<InternalMessageHandler<ApplicationMuleDeploymentNotification>> applicationDeploymentHandlers;
    @Inject
    List<InternalMessageHandler<FlowStatusNotification>> flowStatusHandlers;
    @Inject
    List<InternalMessageHandler<List<com.mulesoft.agent.domain.deployment.Application>>> applicationListHandlers;
    @Inject
    List<InternalMessageHandler<MuleContextNotification>> muleContextNotificationHandlers;
    @Inject
    protected AdministrationService administrationService;
    @Inject
    protected AgentApplicationPropertiesService agentApplicationPropertiesService;
    @Inject
    protected AgentSchedulingService agentSchedulingService;
    @Inject
    private DateService dateService;
    @Inject
    private RuntimeVersionService runtimeVersionService;
    @Inject
    protected ApplicationValidatorService applicationValidatorService;

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public DeploymentListener getDeploymentApplicationListener() {
        return this.deploymentApplicationListener;
    }

    public void doStart() throws MuleException {
        this.deploymentService.addDeploymentListener((DeploymentListener)this.deploymentApplicationListener);
        for (ApplicationConfiguration applicationConfiguration : this.applicationConfigurations) {
            Application application = this.deploymentService.findApplication(applicationConfiguration.getApplicationName());
            if (application == null || application.getStatus() != ApplicationStatus.STARTED) continue;
            this.applyFlowConfigurations(applicationConfiguration.getApplicationName(), applicationConfiguration.getFlowConfigurations());
        }
    }

    public void doStop() throws MuleException {
        this.deploymentService.removeDeploymentListener((DeploymentListener)this.deploymentApplicationListener);
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        ArrayList<InternalMessageHandler> handlerList = new ArrayList<InternalMessageHandler>(this.applicationDeploymentHandlers);
        handlerList.addAll(this.applicationListHandlers);
        return handlerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deploy(String appName, String url, Map<String, Map> configuration) throws AgentDeploymentException, IllegalArgumentException, NoSuchComponentException, InvalidConfigurationException, ApplicationValidationException {
        LOGGER.info("Deploying the {} application from URL {}", (Object)appName, (Object)url);
        ReentrantLock lock = this.deploymentService.getLock();
        URI tempDirPath = null;
        try {
            this.lockDeploymentService(lock);
            URL fileUrl = new URL(url);
            tempDirPath = this.createTempDir();
            File file = new File(new File(tempDirPath), appName + ARTIFACT_EXTENSION);
            BufferedOutputStream outStream = new BufferedOutputStream(FileUtils.openOutputStream((File)file));
            try {
                IOUtils.copyLarge((InputStream)fileUrl.openStream(), (OutputStream)outStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outStream);
            }
            this.deployAppAction(appName, configuration, file.toURI());
            this.unlockDeploymentService(lock);
            this.removeTempDirIfExists(tempDirPath);
            return;
        }
        catch (MalformedURLException e) {
            try {
                LOGGER.error("The URL {} for the application {} is malformed. Error: {}", (Object)url, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "The URL is incorrect"));
                throw new IllegalArgumentException(String.format("The URL %s for the application %s is malformed. Error: %s}", url, appName, ExceptionUtils.getRootCauseMessage((Throwable)e)));
                catch (IOException e2) {
                    LOGGER.error("There the application {} doesn't exist at {}. Error: {}", (Object)appName, (Object)url, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e2));
                    LOGGER.debug((Object)e2);
                    this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "The File does not exist"));
                    throw new IllegalArgumentException(String.format("There the application %s doesn't exist at %s. Error: %s", appName, url, ExceptionUtils.getRootCauseMessage((Throwable)e2)));
                }
                catch (DeploymentException e3) {
                    throw new ConcurrentDeploymentException(String.format("Exception: %s. Cause: %s", e3.getMessage(), e3.getCause().getMessage()));
                }
                catch (MuleRuntimeException e4) {
                    LOGGER.error("There was an error on the Mule Runtime while deploying the application {}. Error: {}", (Object)appName, (Object)e4.getMessage());
                    throw new IllegalArgumentException(String.format("There was an error on the Mule Runtime while deploying the application %s. Error: %s. %s", appName, e4.getMessage(), ExceptionUtils.getRootCauseMessage((Throwable)e4)));
                }
                catch (ApplicationValidationException e5) {
                    this.sendApplicationDeploymentNotification(this.newDeploymentFailedNotification(appName, (Exception)((Object)e5)));
                    throw e5;
                }
            }
            catch (Throwable throwable) {
                this.unlockDeploymentService(lock);
                this.removeTempDirIfExists(tempDirPath);
                throw throwable;
            }
        }
    }

    public void deploy(String appName, InputStream application, Map<String, Map> configuration) throws AgentDeploymentException, IllegalArgumentException, NoSuchComponentException, InvalidConfigurationException, ApplicationValidationException {
        LOGGER.info("Deploying the {} application from jar file.", (Object)appName);
        ReentrantLock lock = this.deploymentService.getLock();
        URI tempDirPath = null;
        try {
            this.lockDeploymentService(lock);
            tempDirPath = this.createTempDir();
            File file = new File(new File(tempDirPath), appName + ARTIFACT_EXTENSION);
            FileUtils.copyInputStreamToFile((InputStream)application, (File)file);
            this.deployAppAction(appName, configuration, file.toURI());
        }
        catch (IOException e) {
            LOGGER.error("The file for the application {} is corrupt. Error: {}", (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "The File is corrupt"));
            throw new IllegalArgumentException(String.format("The file for the application %s is corrupt. Error: %s", appName, ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        catch (MuleRuntimeException e) {
            LOGGER.error("There was an error on the Mule Runtime while deploying the application {}. Error: {}", (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            throw new IllegalArgumentException(String.format("There was an error on the Mule Runtime while deploying the application %s. Error: %s. %s", appName, e.getMessage(), ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        catch (ApplicationValidationException e) {
            this.sendApplicationDeploymentNotification(this.newDeploymentFailedNotification(appName, (Exception)((Object)e)));
            throw e;
        }
        finally {
            this.unlockDeploymentService(lock);
            this.removeTempDirIfExists(tempDirPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String appName) throws ConcurrentDeploymentException, IllegalArgumentException, IllegalAccessException {
        LOGGER.info("Undeploying the {} application.", (Object)appName);
        ReentrantLock lock = this.deploymentService.getLock();
        try {
            this.lockDeploymentService(lock);
            Application application = this.deploymentService.findApplication(appName);
            if (application != null && !ApplicationStatus.DEPLOYMENT_FAILED.equals((Object)application.getStatus()) && !ApplicationStatus.CREATED.equals((Object)application.getStatus())) {
                this.deploymentService.undeploy(appName);
            } else {
                File appFolder = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), appName);
                if (appFolder.exists()) {
                    this.forceUndeploy(appName, appFolder);
                    this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "Nothing to undeploy"));
                } else {
                    this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "Nothing to undeploy"));
                    throw new IllegalArgumentException("Application does not exist:" + appName);
                }
            }
            this.administrationService.removeApplicationConfiguration(appName);
        }
        finally {
            this.unlockDeploymentService(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeploy(String appName, Map<String, Map> configuration) throws AgentDeploymentException, IllegalArgumentException {
        block7: {
            LOGGER.info("Redeploying the {} application.", (Object)appName);
            ReentrantLock lock = this.deploymentService.getLock();
            try {
                this.lockDeploymentService(lock);
                if (this.deploymentService.findApplication(appName) != null) {
                    Properties properties = this.parseConfigurations(configuration, appName);
                    if (this.runtimeVersionService.supportsApplicationDeploymentProperties()) {
                        this.deploymentService.redeploy(appName, properties);
                    } else {
                        if (!properties.isEmpty()) {
                            throw new AgentDeploymentException(String.format("Trying to redeploy an application %s with properties (%s) to an unsupported runtime version v%s.", appName, properties.keySet(), this.runtimeVersionService.getRuntimeVersion()));
                        }
                        this.deploymentService.redeploy(appName);
                    }
                    break block7;
                }
                this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "Nothing to redeploy"));
                throw new IllegalArgumentException("Application does not exist:" + appName);
            }
            finally {
                this.unlockDeploymentService(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void redeploy(String appName, String url, Map<String, Map> configuration) throws AgentDeploymentException, ApplicationValidationException {
        LOGGER.info("Redeploying the {} application from URL {}", (Object)appName, (Object)url);
        ReentrantLock lock = this.deploymentService.getLock();
        RedeploymentDeploymentListener redeploymentListener = null;
        URI tempDirPath = null;
        try {
            this.lockDeploymentService(lock);
            if (this.deploymentService.findApplication(appName) == null) {
                this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "The application does not exist"));
                throw new IllegalArgumentException("Application does not exist:" + appName);
            }
            URL fileUrl = new URL(url);
            tempDirPath = this.createTempDir();
            File file = new File(new File(tempDirPath), appName + ARTIFACT_EXTENSION);
            BufferedOutputStream outStream = new BufferedOutputStream(FileUtils.openOutputStream((File)file));
            try {
                IOUtils.copyLarge((InputStream)fileUrl.openStream(), (OutputStream)outStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outStream);
            }
            if (this.runtimeVersionService.supportsApplicationRedeployment()) {
                this.redeployAppAction(appName, configuration, file.toURI());
            } else {
                redeploymentListener = new RedeploymentDeploymentListener(lock, appName, file.toURI(), configuration);
                this.deploymentService.addDeploymentListener((DeploymentListener)redeploymentListener);
                this.deploymentService.undeploy(appName);
            }
            this.unlockDeploymentService(lock);
            this.removeTempDirIfExists(tempDirPath);
            return;
        }
        catch (ApplicationValidationException e) {
            this.sendApplicationDeploymentNotification(this.newDeploymentFailedNotification(appName, (Exception)((Object)e)));
            throw e;
            catch (IOException e2) {
                LOGGER.error("The application {} doesn't exist at {}. Error: {}", (Object)appName, (Object)url, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e2));
                LOGGER.debug((Object)e2);
                this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "The file does not exist"));
                this.unlockDeploymentService(lock);
                this.removeTempDirIfExists(tempDirPath);
                return;
            }
            catch (Exception e3) {
                try {
                    LOGGER.error("There was an error on the Mule Runtime while redeploying the application {} from URL. Error: {}", (Object)appName, (Object)e3.getMessage());
                    if (redeploymentListener == null) throw e3;
                    this.deploymentService.removeDeploymentListener(redeploymentListener);
                    throw e3;
                }
                catch (Throwable throwable) {
                    this.unlockDeploymentService(lock);
                    this.removeTempDirIfExists(tempDirPath);
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void redeploy(String appName, InputStream application, Map<String, Map> configuration) throws AgentDeploymentException, ApplicationValidationException {
        LOGGER.info("Redeploying the {} application from jar file.", (Object)appName);
        ReentrantLock lock = this.deploymentService.getLock();
        RedeploymentDeploymentListener redeploymentListener = null;
        URI tempDirPath = null;
        try {
            this.lockDeploymentService(lock);
            if (this.deploymentService.findApplication(appName) == null) {
                this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "The application does not exist"));
                throw new IllegalArgumentException("Application does not exist:" + appName);
            }
            tempDirPath = this.createTempDir();
            File file = new File(new File(tempDirPath), appName + ARTIFACT_EXTENSION);
            FileUtils.copyInputStreamToFile((InputStream)application, (File)file);
            if (this.runtimeVersionService.supportsApplicationRedeployment()) {
                this.redeployAppAction(appName, configuration, file.toURI());
            } else {
                redeploymentListener = new RedeploymentDeploymentListener(lock, appName, file.toURI(), configuration);
                this.deploymentService.addDeploymentListener((DeploymentListener)redeploymentListener);
                this.deploymentService.undeploy(appName);
            }
            this.unlockDeploymentService(lock);
            this.removeTempDirIfExists(tempDirPath);
            return;
        }
        catch (ApplicationValidationException e) {
            this.sendApplicationDeploymentNotification(this.newDeploymentFailedNotification(appName, (Exception)((Object)e)));
            throw e;
            catch (IOException e2) {
                LOGGER.error("The file for the application {} is corrupt. Error: {}", (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e2));
                LOGGER.debug((Object)e2);
                this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "The file does not exist"));
                this.unlockDeploymentService(lock);
                this.removeTempDirIfExists(tempDirPath);
                return;
            }
            catch (Exception e3) {
                try {
                    LOGGER.error("There was an error on the Mule Runtime while redeploying the application {} from jar. Error: {}", (Object)appName, (Object)e3.getMessage());
                    if (redeploymentListener == null) throw e3;
                    this.deploymentService.removeDeploymentListener(redeploymentListener);
                    throw e3;
                }
                catch (Throwable throwable) {
                    this.unlockDeploymentService(lock);
                    this.removeTempDirIfExists(tempDirPath);
                    throw throwable;
                }
            }
        }
    }

    public List<com.mulesoft.agent.domain.deployment.Application> listApplications() {
        List<com.mulesoft.agent.domain.deployment.Application> applications = this.convertApplications(this.deploymentService.getApplications());
        this.sendApplicationListNotification(applications);
        return applications;
    }

    public List<com.mulesoft.agent.domain.deployment.Application> listApplications(String domain) {
        List<com.mulesoft.agent.domain.deployment.Application> applications = this.convertApplications(this.deploymentService.findDomainApplications(domain));
        this.sendApplicationListNotification(applications);
        return applications;
    }

    public com.mulesoft.agent.domain.deployment.Application getApplication(String name) {
        Application muleApplication = this.deploymentService.findApplication(name);
        File appFolder = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), name);
        if (muleApplication != null && (muleApplication.getStatus() != ApplicationStatus.CREATED || appFolder.exists())) {
            return new com.mulesoft.agent.domain.deployment.Application(muleApplication.getArtifactName(), this.getApplicationDomain(muleApplication), ArtifactState.valueOf((String)muleApplication.getStatus().toString()), this.getFlows(muleApplication.getArtifactName()), this.applicationsLastDateStarted.get(muleApplication.getArtifactName()));
        }
        return null;
    }

    public String getAssetId(String name) {
        return Arrays.stream(this.applicationConfigurations).filter(l -> Objects.equals(l.getApplicationName(), name)).map(l -> Objects.equals(l.getAssetId(), "") ? "asset-not-found" : l.getAssetId()).findFirst().orElse("conf-not-found");
    }

    private String getApplicationDomain(Application muleApplication) {
        if (muleApplication instanceof DeployableArtifact) {
            return muleApplication.getDomain().getArtifactName();
        }
        throw new AgentApplicationConfigurationException("There was an error while getting the domain of application " + muleApplication.getArtifactName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.mulesoft.agent.domain.deployment.Application getApplicationSynchronized(String name) throws ConcurrentDeploymentException {
        ReentrantLock lock = this.deploymentService.getLock();
        try {
            this.lockDeploymentService(lock);
            com.mulesoft.agent.domain.deployment.Application application = this.getApplication(name);
            return application;
        }
        finally {
            this.unlockDeploymentService(lock);
        }
    }

    public void stop(String appName) throws ConcurrentDeploymentException, IllegalArgumentException, IllegalStateException {
        LOGGER.info("Stopping the application {}.", (Object)appName);
        this.changeApplicationStatus(appName, ApplicationStatus.STOPPED, DeployableArtifact::stop);
    }

    public void start(String appName) throws ConcurrentDeploymentException, IllegalArgumentException, IllegalStateException {
        LOGGER.info("Starting the application {}.", (Object)appName);
        this.changeApplicationStatus(appName, ApplicationStatus.STARTED, DeployableArtifact::start);
    }

    public List<com.mulesoft.agent.domain.flows.Flow> getFlows(String applicationName) throws IllegalArgumentException {
        ArrayList<com.mulesoft.agent.domain.flows.Flow> flows = new ArrayList<com.mulesoft.agent.domain.flows.Flow>();
        Collection<Flow> muleFlows = this.getMuleFlows(applicationName);
        for (Flow muleFlow : muleFlows) {
            com.mulesoft.agent.domain.flows.Flow flow = new com.mulesoft.agent.domain.flows.Flow();
            flow.setName(muleFlow.getName());
            flow.setStatus(this.extractFlowStatus(muleFlow));
            flow.setDefaultStatus(FlowStatus.valueOf((String)muleFlow.getInitialState().toUpperCase()));
            flows.add(flow);
        }
        return flows;
    }

    public void stopFlow(String applicationName, String flowName) throws IllegalArgumentException, AgentApplicationConfigurationException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Flow muleFlow = this.getMuleFlow(applicationName, flowName).orElseThrow(() -> new IllegalArgumentException("Application " + applicationName + " or flow " + flowName + " does not exist."));
            if (!muleFlow.getLifecycleState().isStopped()) {
                Thread.currentThread().setContextClassLoader(muleFlow.getMuleContext().getExecutionClassLoader());
                muleFlow.stop();
            }
        }
        catch (MuleException e) {
            LOGGER.error("There was an error on the Mule Runtime while stopping the flow {} of the application {}. Error: {}", (Object)flowName, (Object)applicationName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            throw new AgentApplicationConfigurationException("There was an error on the Mule Runtime while stopping the flow " + flowName + "of application " + applicationName + ": " + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public void startFlow(String applicationName, String flowName) throws IllegalArgumentException, AgentApplicationConfigurationException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Flow muleFlow = this.getMuleFlow(applicationName, flowName).orElseThrow(() -> new IllegalArgumentException("Application " + applicationName + " or flow " + flowName + " does not exist."));
            if (!muleFlow.getLifecycleState().isStarted()) {
                Thread.currentThread().setContextClassLoader(muleFlow.getMuleContext().getExecutionClassLoader());
                muleFlow.start();
                this.agentSchedulingService.applySchedulerConfigurationsManagedInApplicationDescriptor(applicationName, flowName);
            }
        }
        catch (MuleException e) {
            LOGGER.error("There was an error on the Mule Runtime while starting the flow {} of the application {}. Error: {}", (Object)flowName, (Object)applicationName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            throw new AgentApplicationConfigurationException("There was an error on the Mule Runtime while stopping the flow " + flowName + "of application " + applicationName + ": " + e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public List<EventContextService.FlowStackEntry> getCurrentlyActiveFlowStacks(String applicationName) throws NoSuchApplicationException {
        Application application = this.deploymentService.findApplication(applicationName);
        if (application == null) {
            throw new NoSuchApplicationException("Application does not exist:" + applicationName);
        }
        EventContextService eventContextService = (EventContextService)application.getRegistry().lookupByName("_muleEventContextService").orElseThrow(() -> new IllegalArgumentException(String.format("Could not get EventContextService for application %s.", applicationName)));
        return eventContextService.getCurrentlyActiveFlowStacks();
    }

    private Optional<Flow> getMuleFlow(String applicationName, String flowName) {
        return Optional.ofNullable(this.deploymentService.findApplication(applicationName)).map(DeployableArtifact::getRegistry).flatMap(registry -> registry.lookupByName(flowName));
    }

    private Collection<Flow> getMuleFlows(String applicationName) {
        return Optional.ofNullable(this.deploymentService.findApplication(applicationName)).map(DeployableArtifact::getRegistry).map(registry -> registry.lookupAllByType(Flow.class)).orElse(new LinkedList());
    }

    private FlowStatus extractFlowStatus(Flow muleFlow) {
        LifecycleState lifecycleState = muleFlow.getLifecycleState();
        if (lifecycleState.isStarted()) {
            return FlowStatus.STARTED;
        }
        return FlowStatus.STOPPED;
    }

    private List<com.mulesoft.agent.domain.deployment.Application> convertApplications(Collection<Application> muleApplications) {
        LinkedList<com.mulesoft.agent.domain.deployment.Application> applications = new LinkedList<com.mulesoft.agent.domain.deployment.Application>();
        for (Application muleApplication : muleApplications) {
            applications.add(new com.mulesoft.agent.domain.deployment.Application(muleApplication.getArtifactName(), this.getApplicationDomain(muleApplication), ArtifactState.valueOf((String)muleApplication.getStatus().toString()), this.getFlows(muleApplication.getArtifactName()), this.applicationsLastDateStarted.get(muleApplication.getArtifactName())));
        }
        return applications;
    }

    private void sendApplicationDeploymentNotification(ApplicationMuleDeploymentNotification message) {
        for (InternalMessageHandler<ApplicationMuleDeploymentNotification> handler : this.applicationDeploymentHandlers) {
            handler.handle((Object)message);
        }
    }

    private void sendFlowStatusNotification(FlowStatusNotification message) {
        for (InternalMessageHandler<FlowStatusNotification> handler : this.flowStatusHandlers) {
            handler.handle((Object)message);
        }
    }

    private void sendApplicationListNotification(List<com.mulesoft.agent.domain.deployment.Application> message) {
        for (InternalMessageHandler<List<com.mulesoft.agent.domain.deployment.Application>> handler : this.applicationListHandlers) {
            handler.handle(message);
        }
    }

    private void forceUndeploy(String appName, File appFolder) {
        try {
            FileUtils.deleteDirectory((File)appFolder);
        }
        catch (IOException e) {
            LOGGER.error("Application " + appName + " could not be undeployed by any means");
            LOGGER.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeApplicationStatus(String appName, ApplicationStatus notAllowedPreviousStatus, Consumer<Application> changeApplicationStatus) throws ConcurrentDeploymentException, IllegalArgumentException, IllegalStateException {
        ReentrantLock lock = this.deploymentService.getLock();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.lockDeploymentService(lock);
            Application application = this.deploymentService.findApplication(appName);
            if (application == null) {
                throw new IllegalArgumentException("Application does not exist:" + appName);
            }
            if (application.getStatus() == notAllowedPreviousStatus) {
                throw new IllegalStateException();
            }
            Thread.currentThread().setContextClassLoader(application.getArtifactClassLoader().getClassLoader());
            changeApplicationStatus.accept(application);
            MuleContext muleContext = Optional.ofNullable(application.getArtifactContext()).map(ArtifactContext::getMuleContext).orElse(null);
            if (notAllowedPreviousStatus.equals((Object)ApplicationStatus.STOPPED) && application.getStatus().equals((Object)ApplicationStatus.CREATED) && (muleContext == null || muleContext.isInitialised())) {
                this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.CREATED), DeploymentStatus.CONTEXT_STOPPED, ""));
            }
        }
        finally {
            this.unlockDeploymentService(lock);
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private URI createTempDir() throws IOException {
        try {
            URI uri = Files.createTempDirectory("mule-received-artifact-", new FileAttribute[0]).toUri();
            File dir = new File(uri);
            dir.setReadable(true, false);
            dir.setWritable(true, false);
            dir.setExecutable(true, false);
            return uri;
        }
        catch (Exception e) {
            LOGGER.error("Could not create temporary directory for mule artifact deployment.  Exception was: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            throw new IOException(e);
        }
    }

    private void removeTempDirIfExists(URI path) {
        if (path == null) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)new File(path));
            Files.deleteIfExists(Paths.get(path));
        }
        catch (Exception e) {
            LOGGER.error("Could not remove temporary directory used for mule artifact deployment.  Exception was: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
        }
    }

    private void lockDeploymentService(ReentrantLock lock) throws ConcurrentDeploymentException {
        try {
            if (!lock.tryLock(250L, TimeUnit.MILLISECONDS)) {
                throw new ConcurrentDeploymentException("There is another deployment operation in progress. Retry later");
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Unable to get lock, the thread was interrupted.", (Throwable)e);
            throw new ConcurrentDeploymentException("There are multiples deployment requests at the same time, this will be ignored. Retry Later");
        }
    }

    private void unlockDeploymentService(ReentrantLock lock) {
        LOGGER.debug("Trying to release the lock {}.", (Object)lock);
        if (lock.isHeldByCurrentThread()) {
            lock.unlock();
            LOGGER.debug("Successfully released the lock {}.", (Object)lock);
        }
    }

    private void applyFlowConfigurations(String appName, FlowConfiguration[] flowConfigurations) {
        for (FlowConfiguration flowConfiguration : flowConfigurations) {
            try {
                if (flowConfiguration.getFlowStatus() == FlowStatus.STOPPED) {
                    this.stopFlow(appName, flowConfiguration.getFlowName());
                    continue;
                }
                this.startFlow(appName, flowConfiguration.getFlowName());
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("Flow {} for application {} is not present so its status cannot be changed", (Object)flowConfiguration.getFlowName(), (Object)appName);
                LOGGER.debug((Object)e);
            }
        }
    }

    private Properties parseConfigurations(Map<String, Map> configuration, String appName) {
        if (configuration == null) {
            return new Properties();
        }
        for (Map.Entry<String, Map> entry : configuration.entrySet()) {
            String componentId = entry.getKey();
            Map configurationAsMap = entry.getValue();
            LOGGER.info("Parsing config for: " + entry.getKey());
            try {
                com.mulesoft.agent.configuration.ApplicationConfiguration applicationConfiguration = this.administrationService.parseApplicationConfiguration(componentId, configurationAsMap);
                this.administrationService.updateApplicationConfiguration(componentId, applicationConfiguration, appName);
            }
            catch (NoSuchElementException e) {
                LOGGER.warn("Invalid reference in configuration for application '{}': Component '{}' does not exist", (Object)appName, (Object)componentId);
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn("Invalid reference in configuration for application '{}': Component '{}' does not allow dynamic application configuration", (Object)appName, (Object)componentId);
            }
            catch (JsonSyntaxException | InvalidConfigurationException e) {
                LOGGER.warn("Could not parse value for the component '{}' for application '{}'", (Object)componentId, (Object)appName);
            }
            catch (ComponentOperationException e) {
                LOGGER.warn("Could not update configuration for application '{}' and component '{}'", (Object)appName, (Object)componentId);
            }
            catch (AgentEnableOperationException e) {
                LOGGER.error("Unable to update configuration for application: '{}' component: '{}'", (Object)appName, (Object)entry.getKey(), (Object)e);
            }
        }
        return this.agentApplicationPropertiesService.getPropertiesForApplication(appName);
    }

    private void deployAppAction(String appName, Map<String, Map> configuration, URI uri) throws IOException, AgentDeploymentException, ApplicationValidationException {
        this.validateApplication(appName, configuration, uri);
        try {
            DeploymentConfigurationManager.create().from(appName, configuration).using(this.administrationService).parse().update();
            Properties properties = this.replaceApplicationConfigurationAndGet(appName, configuration);
            this.validateApplicationPropertiesSupport(appName, properties);
            if (configuration == null && properties.isEmpty()) {
                this.deploymentService.deploy(uri);
            } else {
                this.deploymentService.deploy(uri, properties);
            }
        }
        catch (ComponentOperationException | InvalidConfigurationException | NoSuchComponentException | NoSuchFieldException e) {
            throw new AgentDeploymentException(String.format("Invalid application configuration for application '%s': %s", appName, e.getMessage()));
        }
    }

    private void validateApplication(String appName, Map<String, Map> configuration, URI uri) throws IOException, ApplicationValidationException {
        Map propertiesConfiguration;
        Map props = null;
        if (configuration != null && (propertiesConfiguration = configuration.get("mule.agent.application.properties.service")) != null && propertiesConfiguration.get("properties") instanceof Map) {
            props = (Map)propertiesConfiguration.get("properties");
        }
        this.applicationValidatorService.validate(appName, uri, props);
    }

    private void redeployAppAction(String appName, Map<String, Map> configuration, URI uri) throws IOException, AgentDeploymentException, ApplicationValidationException {
        this.validateApplication(appName, configuration, uri);
        try {
            DeploymentConfigurationManager.create().from(appName, configuration).using(this.administrationService).parse().update();
            Properties properties = this.replaceApplicationConfigurationAndGet(appName, configuration);
            this.validateApplicationPropertiesSupport(appName, properties);
            this.deploymentService.redeploy(uri, properties);
        }
        catch (ComponentOperationException | InvalidConfigurationException | NoSuchComponentException | NoSuchFieldException e) {
            throw new AgentDeploymentException(String.format("Invalid application configuration for application '%s': %s", appName, e.getMessage()));
        }
    }

    private void validateApplicationPropertiesSupport(String appName, Properties properties) throws AgentDeploymentException {
        if (!properties.isEmpty() && !this.runtimeVersionService.supportsApplicationDeploymentProperties()) {
            throw new AgentDeploymentException(String.format("Trying to deploy an application %s with properties (%s) to an unsupported runtime version v%s.", appName, properties.keySet(), this.runtimeVersionService.getRuntimeVersion()));
        }
    }

    private Properties replaceApplicationConfigurationAndGet(String appName, Map<String, Map> configuration) {
        Properties properties = null;
        properties = configuration == null ? this.agentApplicationPropertiesService.getPropertiesForApplication(appName) : this.parseConfigurations(configuration, appName);
        return properties;
    }

    private void enforceFlowStateManagedInApplicationDescriptor(String applicationName) {
        ApplicationConfiguration desiredApplicationConfiguration = null;
        for (ApplicationConfiguration applicationConfiguration : this.applicationConfigurations) {
            if (!applicationName.equals(applicationConfiguration.getApplicationName())) continue;
            desiredApplicationConfiguration = applicationConfiguration;
        }
        if (desiredApplicationConfiguration != null) {
            this.applyFlowConfigurations(applicationName, desiredApplicationConfiguration.getFlowConfigurations());
        }
    }

    public void triggerFlow(String applicationName, String flowName) {
        this.agentSchedulingService.triggerScheduler(applicationName, flowName);
    }

    private ApplicationMuleDeploymentNotification newDeploymentFailedNotification(String appName, Exception e) {
        return new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DEPLOYMENT_FAILED), DeploymentStatus.DEPLOYMENT_FAILED, String.format("%s. %s", e.getMessage(), ExceptionUtils.getRootCauseMessage((Throwable)e)));
    }

    private class FlowNotificationListener
    implements FlowConstructNotificationListener<FlowConstructNotification> {
        private String appName;

        public FlowNotificationListener(String appName) {
            this.appName = appName;
        }

        public void onNotification(FlowConstructNotification notification) {
            AgentApplicationService.this.getMuleFlow(this.appName, notification.getResourceIdentifier()).ifPresent(muleFlow -> {
                com.mulesoft.agent.domain.flows.Flow flow = new com.mulesoft.agent.domain.flows.Flow(muleFlow.getName(), AgentApplicationService.this.extractFlowStatus(muleFlow), FlowStatus.valueOf((String)muleFlow.getInitialState().toUpperCase()));
                AgentApplicationService.this.sendFlowStatusNotification(new FlowStatusNotification(this.appName, flow));
            });
        }
    }

    private class RedeploymentDeploymentListener
    implements DeploymentListener {
        private ReentrantLock lock;
        private String appName;
        private URI uri;
        private Map<String, Map> configuration;

        RedeploymentDeploymentListener(ReentrantLock lock, String appName, URI uri, Map<String, Map> configuration) {
            this.lock = lock;
            this.appName = appName;
            this.uri = uri;
            this.configuration = configuration;
        }

        public void onUndeploymentSuccess(String appName) {
            if (appName.equals(this.appName)) {
                try {
                    AgentApplicationService.this.deployAppAction(appName, this.configuration, this.uri);
                }
                catch (IOException e) {
                    AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, "Failure in deployment stage of redeployment"));
                }
                catch (AgentDeploymentException e) {
                    throw new RuntimeAgentDeploymentException(String.format("Error deploying application %s.", appName), (Exception)((Object)e));
                }
                catch (ApplicationValidationException e) {
                    throw new RuntimeAgentDeploymentException(String.format("Error deploying application %s.", appName), (Exception)((Object)e));
                }
                finally {
                    AgentApplicationService.this.deploymentService.removeDeploymentListener((DeploymentListener)this);
                    AgentApplicationService.this.unlockDeploymentService(this.lock);
                }
            }
        }

        public void onUndeploymentFailure(String appName, Throwable cause) {
            if (appName.equals(this.appName)) {
                AgentApplicationService.this.unlockDeploymentService(this.lock);
                AgentApplicationService.this.deploymentService.removeDeploymentListener((DeploymentListener)this);
            }
        }
    }

    private class AgentApplicationDeploymentListener
    implements DeploymentListener {
        private AgentApplicationDeploymentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDeploymentSuccess(String appName) {
            List<Object> flows = new ArrayList();
            try {
                flows = AgentApplicationService.this.getFlows(appName);
            }
            catch (Exception e) {
                LOGGER.error("There was an error configuring the flows of application {}. Error: {}", (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
            finally {
                Application application = AgentApplicationService.this.deploymentService.findApplication(appName);
                if (application.getStatus().equals((Object)ApplicationStatus.CREATED)) {
                    AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.CREATED, flows, AgentApplicationService.this.dateService.getDate()), DeploymentStatus.CONTEXT_STOPPED, ""));
                } else {
                    AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.STARTED, flows, AgentApplicationService.this.dateService.getDate()), DeploymentStatus.DEPLOYED, ""));
                }
            }
        }

        public void onDeploymentStart(String appName) {
            AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.CREATED), DeploymentStatus.DEPLOYMENT_STARTED, ""));
        }

        public void onDeploymentFailure(String appName, Throwable cause) {
            AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DEPLOYMENT_FAILED), DeploymentStatus.DEPLOYMENT_FAILED, String.format("%s. %s", cause.getMessage(), ExceptionUtils.getRootCauseMessage((Throwable)cause))));
        }

        public void onArtifactCreated(String appName, CustomizationService customizationService) {
            AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.CREATED), DeploymentStatus.CONTEXT_CREATED, ""));
        }

        public void onArtifactInitialised(String appName, Registry registry) {
            List<com.mulesoft.agent.domain.flows.Flow> flows = AgentApplicationService.this.getFlows(appName);
            AgentApplicationService.this.applicationsLastDateStarted.put(appName, AgentApplicationService.this.dateService.getDate());
            AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.INITIALISED, flows, (Date)AgentApplicationService.this.applicationsLastDateStarted.get(appName)), DeploymentStatus.CONTEXT_INITIALISED, ""));
            NotificationListenerRegistry notificationRegistry = (NotificationListenerRegistry)registry.lookupByName("_muleNotificationListenerRegistry").get();
            notificationRegistry.registerListener((NotificationListener)new FlowNotificationListener(appName));
            notificationRegistry.registerListener((NotificationListener)new ContextNotificationHandler(appName, AgentApplicationService.this.muleContextNotificationHandlers));
        }

        public void onArtifactStarted(String artifactName, Registry registry) {
            List<com.mulesoft.agent.domain.flows.Flow> flows = AgentApplicationService.this.getFlows(artifactName);
            AgentApplicationService.this.applicationsLastDateStarted.put(artifactName, AgentApplicationService.this.dateService.getDate());
            AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(artifactName, ArtifactState.STARTED, flows, (Date)AgentApplicationService.this.applicationsLastDateStarted.get(artifactName)), DeploymentStatus.CONTEXT_STARTED, ""));
            this.loadApplicationConfigurations(artifactName);
            AgentApplicationService.this.enforceFlowStateManagedInApplicationDescriptor(artifactName);
        }

        public void onArtifactStopped(String artifactName, Registry registry) {
            AgentApplicationService.this.applicationsLastDateStarted.remove(artifactName);
            AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(artifactName, ArtifactState.STOPPED), DeploymentStatus.CONTEXT_STOPPED, ""));
        }

        public void onUndeploymentStart(String appName) {
            AgentApplicationService.this.applicationsLastDateStarted.remove(appName);
            AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.STARTED), DeploymentStatus.UNDEPLOYING, ""));
        }

        public void onUndeploymentSuccess(String appName) {
            AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.DESTROYED), DeploymentStatus.UNDEPLOYED, ""));
        }

        public void onUndeploymentFailure(String appName, Throwable cause) {
            AgentApplicationService.this.sendApplicationDeploymentNotification(new ApplicationMuleDeploymentNotification(new com.mulesoft.agent.domain.deployment.Application(appName, ArtifactState.STARTED), DeploymentStatus.UNDEPLOYMENT_FAILED, "Undeployment failed " + cause.getMessage()));
        }

        private void loadApplicationConfigurations(String appName) {
            try {
                Map applicationComponentConfigurations = AgentApplicationService.this.administrationService.loadApplicationConfigurationsFromDescriptor(appName);
                if (applicationComponentConfigurations == null) {
                    LOGGER.warn("Application fragment not found for application: {}", (Object)appName);
                    return;
                }
                for (String componentId : applicationComponentConfigurations.keySet()) {
                    LOGGER.info("Loading application configuration from fragment: {}", (Object)componentId);
                    Map fieldComponentConfiguration = (Map)applicationComponentConfigurations.get(componentId);
                    for (String fieldName : fieldComponentConfiguration.keySet()) {
                        List fieldConfigurations = (List)fieldComponentConfiguration.get(fieldName);
                        try {
                            com.mulesoft.agent.configuration.ApplicationConfiguration[] configuration = AgentApplicationService.this.administrationService.parseApplicationConfiguration(componentId, fieldName, (Object)fieldConfigurations);
                            AgentApplicationService.this.administrationService.updateApplicationConfiguration(componentId, fieldName, configuration, appName);
                        }
                        catch (NoSuchElementException e) {
                            LOGGER.warn("Invalid reference in configuration file for application '{}': Component '{}' does not exist", (Object)appName, (Object)componentId);
                        }
                        catch (NoSuchFieldException e) {
                            LOGGER.warn("Invalid reference in configuration file for application '{}': Reference '{}' does not exist in component '{}'", (Object)appName, (Object)fieldName, (Object)componentId);
                        }
                        catch (InvalidFieldException e) {
                            LOGGER.warn("Invalid reference in configuration file for application '{}': Reference '{}' does not accept dynamic application configuration", (Object)appName, (Object)fieldName, (Object)componentId);
                        }
                        catch (JsonSyntaxException | InvalidConfigurationException e) {
                            LOGGER.warn("Could not parse value for the field '{}' in component '{}' for application '{}'", (Object)fieldName, (Object)componentId, (Object)appName);
                        }
                        catch (ComponentOperationException e) {
                            LOGGER.warn("Could not update configuration for application '{}' and component '{}'", (Object)appName, (Object)componentId);
                        }
                    }
                }
            }
            catch (AgentEnableOperationException e) {
                LOGGER.error("Agent is disabeld. Unable to update configuration for application {}", (Object)appName, (Object)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Unable to update configuration for application {}", (Object)appName, (Object)e);
            }
            catch (Exception e) {
                LOGGER.error("Unable to parse configuration for application {}", (Object)appName, (Object)e);
            }
        }
    }
}

