/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.tls.AbstractTlsClient;
import org.bouncycastle.tls.BasicTlsSRPIdentity;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSRPIdentity;
import org.bouncycastle.tls.TlsSRPUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;

public class SRPTlsClient
extends AbstractTlsClient {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{49182};
    protected TlsSRPIdentity srpIdentity;

    public SRPTlsClient(TlsCrypto crypto, byte[] identity, byte[] password) {
        this(crypto, new BasicTlsSRPIdentity(identity, password));
    }

    public SRPTlsClient(TlsCrypto crypto, TlsSRPIdentity srpIdentity) {
        super(crypto);
        this.srpIdentity = srpIdentity;
    }

    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.only();
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(clientExtensions, this.srpIdentity.getSRPIdentity());
        return clientExtensions;
    }

    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(serverExtensions, TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(serverExtensions);
    }

    public TlsSRPIdentity getSRPIdentity() {
        return this.srpIdentity;
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }
}

