/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.ArrayUtil;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TlsNullCipher
implements TlsCipher {
    private final TlsSuiteHMac readMac;
    private final TlsSuiteHMac writeMac;
    private final byte[] decryptConnectionID;
    private final byte[] encryptConnectionID;
    private final boolean decryptUseInnerPlaintext;
    private final boolean encryptUseInnerPlaintext;

    public TlsNullCipher(TlsCryptoParameters tlsCryptoParameters, TlsHMAC tlsHMAC, TlsHMAC tlsHMAC2) throws IOException {
        SecurityParameters securityParameters = tlsCryptoParameters.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (TlsImplUtils.isTLSv13(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.decryptConnectionID = securityParameters.getConnectionIDPeer();
        this.encryptConnectionID = securityParameters.getConnectionIDLocal();
        this.decryptUseInnerPlaintext = !ArrayUtil.isNullOrEmpty(this.decryptConnectionID);
        this.encryptUseInnerPlaintext = !ArrayUtil.isNullOrEmpty(this.encryptConnectionID);
        int n = tlsHMAC.getMacLength() + tlsHMAC2.getMacLength();
        byte[] byArray = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n);
        int n2 = 0;
        tlsHMAC.setKey(byArray, n2, tlsHMAC.getMacLength());
        tlsHMAC2.setKey(byArray, n2 += tlsHMAC.getMacLength(), tlsHMAC2.getMacLength());
        if ((n2 += tlsHMAC2.getMacLength()) != n) {
            throw new TlsFatalAlert(80);
        }
        if (tlsCryptoParameters.isServer()) {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
        } else {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
        }
    }

    @Override
    public int getCiphertextDecodeLimit(int n) {
        int n2 = n + (this.decryptUseInnerPlaintext ? 1 : 0);
        return n2 + this.readMac.getSize();
    }

    @Override
    public int getCiphertextEncodeLimit(int n) {
        int n2 = n + (this.encryptUseInnerPlaintext ? 1 : 0);
        return n2 + this.writeMac.getSize();
    }

    @Override
    public int getPlaintextDecodeLimit(int n) {
        int n2 = n - this.readMac.getSize();
        return n2 - (this.decryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public int getPlaintextEncodeLimit(int n) {
        int n2 = n - this.writeMac.getSize();
        return n2 - (this.encryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public TlsEncodeResult encodePlaintext(long l, short s, ProtocolVersion protocolVersion, int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.writeMac.getSize();
        int n5 = n3 + (this.encryptUseInnerPlaintext ? 1 : 0);
        byte[] byArray2 = new byte[n + n5 + n4];
        System.arraycopy(byArray, n2, byArray2, n, n3);
        short s2 = s;
        if (this.encryptUseInnerPlaintext) {
            byArray2[n + n3] = (byte)s;
            s2 = 25;
        }
        byte[] byArray3 = this.writeMac.calculateMac(l, s2, this.encryptConnectionID, byArray2, n, n5);
        System.arraycopy(byArray3, 0, byArray2, n + n5, byArray3.length);
        return new TlsEncodeResult(byArray2, 0, byArray2.length, s2);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long l, short s, ProtocolVersion protocolVersion, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        short s2;
        block3: {
            byte by;
            boolean bl;
            int n4 = this.readMac.getSize();
            int n5 = n2 - n4;
            if (n5 < (this.decryptUseInnerPlaintext ? 1 : 0)) {
                throw new TlsFatalAlert(50);
            }
            byte[] byArray2 = this.readMac.calculateMac(l, s, this.decryptConnectionID, byArray, n, n5);
            boolean bl2 = bl = !TlsUtils.constantTimeAreEqual(n4, byArray2, 0, byArray, n + n5);
            if (bl) {
                throw new TlsFatalAlert(20);
            }
            s2 = s;
            n3 = n5;
            if (!this.decryptUseInnerPlaintext) break block3;
            do {
                if (--n3 >= 0) continue;
                throw new TlsFatalAlert(10);
            } while (0 == (by = byArray[n + n3]));
            s2 = (short)(by & 0xFF);
        }
        return new TlsDecodeResult(byArray, n, n3, s2);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return this.decryptUseInnerPlaintext;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return this.encryptUseInnerPlaintext;
    }
}

