/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.icons;

import java.awt.RenderingHints;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.mule.tooling.icons.IconGenerationException;
import org.mule.tooling.icons.IconsGenerator;

public class SvgToPngConverter
implements IconsGenerator {
    private final PNGTranscoder transcoder = this.setupTranscoder();

    private SvgToPngConverter() {
    }

    private PNGTranscoder setupTranscoder() {
        return new PNGTranscoder(){

            protected ImageRenderer createRenderer() {
                ImageRenderer renderer = super.createRenderer();
                RenderingHints hints = renderer.getRenderingHints();
                hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
                hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
                hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
                hints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE));
                hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
                hints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
                renderer.setRenderingHints(hints);
                return renderer;
            }
        };
    }

    public static SvgToPngConverter newSvgToPngConverter() {
        return new SvgToPngConverter();
    }

    @Override
    public synchronized void toPng(int width, int height, ByteArrayInputStream source, Path pngPath) throws IconGenerationException {
        this.transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
        this.transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
        TranscoderInput input = new TranscoderInput((InputStream)source);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream ostream = new FileOutputStream(pngPath.toFile());){
                TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                this.transcoder.transcode(input, output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            try {
                Files.deleteIfExists(pngPath);
            }
            catch (IOException iOException) {}
            throw new IconGenerationException("Unexpected error generating icon", ex);
        }
    }
}

