/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.icons;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.images.StudioImages;
import org.mule.tooling.utils.LazyValue;

public class ImagesManager {
    private LazyValue<ImageRegistry> registry = new LazyValue(() -> new ImageRegistry(Display.getDefault()));
    private Map<String, URL> registeredImages = new HashMap<String, URL>();
    private static final String SMALL_UNKNOWN_IMAGE_ID = "org.mule.tooling.unknown.small";
    private static final String LARGE_UNKNOWN_IMAGE_ID = "org.mule.tooling.unknown.large";
    private static final String COMMENT_IMAGE_ID = "org.mule.tooling.comment";
    private static final String SMALL_COMMENT_IMAGE_ID = "org.mule.tooling.comment.small";
    private static final String COMMENT_CONTAINER_IMAGE_ID = "org.mule.tooling.comment.container";

    public static ImagesManager getInstance() {
        return ImagesManagerHolder.INSTANCE;
    }

    private ImagesManager() {
        try {
            this.registeredImages.put(SMALL_UNKNOWN_IMAGE_ID, new URL("platform:/plugin/org.mule.tooling.images/images/palette/generic.png"));
            this.registeredImages.put(LARGE_UNKNOWN_IMAGE_ID, new URL("platform:/plugin/org.mule.tooling.images/images/canvas/generic.png"));
            this.registeredImages.put(COMMENT_IMAGE_ID, new URL("platform:/plugin/org.mule.tooling.images/images/canvas/comment.png"));
            this.registeredImages.put(SMALL_COMMENT_IMAGE_ID, new URL("platform:/plugin/org.mule.tooling.images/images/palette/comment.png"));
            this.registeredImages.put(COMMENT_CONTAINER_IMAGE_ID, new URL("platform:/plugin/org.mule.tooling.images/images/canvas/comment-container.png"));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor descriptor = ((ImageRegistry)this.registry.getOrCompute()).getDescriptor(key);
        if (descriptor != null) {
            return descriptor;
        }
        URL imageURL = this.registeredImages.get(key);
        descriptor = StudioImages.PALETTE_GENERIC;
        if (imageURL != null) {
            if (FileLocator.find((URL)imageURL) != null) {
                descriptor = ImageDescriptor.createFromURL((URL)imageURL);
                ((ImageRegistry)this.registry.getOrCompute()).put(key, descriptor);
            } else if (imageURL.getProtocol().equals("file")) {
                descriptor = this.getOrCreateFromFile(key, imageURL, descriptor);
            }
        }
        return descriptor;
    }

    private ImageDescriptor getOrCreateFromFile(String key, URL imageURL, ImageDescriptor defaultImage) {
        try {
            File iconFile = new File(imageURL.toURI());
            if (iconFile.exists()) {
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageURL);
                ((ImageRegistry)this.registry.getOrCompute()).put(key, descriptor);
                return descriptor;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return defaultImage;
    }

    public Image getImage(String key) {
        Image image = ((ImageRegistry)this.registry.getOrCompute()).get(key);
        if (image == null) {
            this.getImageDescriptor(key);
            return ((ImageRegistry)this.registry.getOrCompute()).get(key);
        }
        return image;
    }

    public void register(String key, URL imageDescriptor) {
        this.registeredImages.put(key, imageDescriptor);
    }

    public ImageDescriptor getCanvasUnknownDescriptor() {
        return this.getImageDescriptor(LARGE_UNKNOWN_IMAGE_ID);
    }

    public ImageDescriptor getPaletteUnknownDescriptor() {
        return this.getImageDescriptor(SMALL_UNKNOWN_IMAGE_ID);
    }

    public Image getCanvasUnknown() {
        return this.getImage(LARGE_UNKNOWN_IMAGE_ID);
    }

    public Image getPaletteUnknown() {
        return this.getImage(SMALL_UNKNOWN_IMAGE_ID);
    }

    public Image getCanvasComment() {
        return this.getImage(COMMENT_IMAGE_ID);
    }

    public Image getPaletteComment() {
        return this.getImage(SMALL_COMMENT_IMAGE_ID);
    }

    public Image getCanvasCommentContainer() {
        return this.getImage(COMMENT_CONTAINER_IMAGE_ID);
    }

    private static class ImagesManagerHolder {
        private static final ImagesManager INSTANCE = new ImagesManager();

        private ImagesManagerHolder() {
        }
    }
}

