/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.icons;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.images.StudioImages;

public class ImageUtils {
    public static final String CANVAS_IMAGE = "canvas";
    public static final String PALETTE_IMAGE = "palette";

    private ImageUtils() {
    }

    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(data.width, data.height, 2);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int mc = data.getAlpha(x, y) << 24;
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, mc | rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    public static BufferedImage colorImage(BufferedImage loadImg, int red, int green, int blue, int alpha) {
        Graphics g = loadImg.getGraphics();
        g.setColor(new Color(red, green, blue, alpha));
        g.fillRect(0, 0, loadImg.getWidth(), loadImg.getHeight());
        g.dispose();
        return loadImg;
    }

    public static Image createTransparentImage(Display display, int width, int height) {
        ImageData imData = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
        imData.setAlpha(0, 0, 0);
        Arrays.fill(imData.alphaData, (byte)0);
        return new Image((Device)display, imData);
    }

    public static ImageData convertToGray(ImageData imageData) {
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                int intensity = ImageUtils.grayIntensity(red, green, blue);
                imageData.setPixel(i, j, ImageUtils.colorToRGB(imageData.getAlpha(i, j), intensity, intensity, intensity));
                ++j;
            }
            ++i;
        }
        return imageData;
    }

    private static int grayIntensity(int red, int green, int blue) {
        int intensity = (int)(0.21f * (float)red + 0.71f * (float)green + 0.07f * (float)blue);
        return (intensity += 40) > 255 ? 255 : intensity;
    }

    private static int colorToRGB(int alpha, int red, int green, int blue) {
        int newPixel = 0;
        newPixel += alpha;
        newPixel <<= 8;
        newPixel += red;
        newPixel <<= 8;
        newPixel += green;
        newPixel <<= 8;
        return newPixel += blue;
    }

    public static ImageDescriptor getImageOrGeneric(String type, String name) {
        Optional<ImageDescriptor> image = ImageUtils.findImage(name);
        if (!image.isPresent()) {
            if (type.equals(CANVAS_IMAGE)) {
                return StudioImages.CANVAS_GENERIC;
            }
            return StudioImages.PALETTE_GENERIC;
        }
        return image.get();
    }

    public static boolean hasCustomStudioImage(String imageKey) {
        return ImageUtils.findImage(imageKey).isPresent();
    }

    public static Optional<ImageDescriptor> findImage(String name) {
        URL platformURL;
        URL imageURL = ImageUtils.getImageURLFrom(name);
        if (imageURL != null && (platformURL = FileLocator.find((URL)imageURL)) != null) {
            return Optional.of(ImageDescriptor.createFromURL((URL)platformURL));
        }
        return Optional.empty();
    }

    public static URL getImageURLFrom(String imageKey) {
        try {
            if (imageKey != null && imageKey.startsWith("images:")) {
                String file = imageKey.replace("images:/", "");
                return new URL("platform:/plugin/org.mule.tooling.images/images/" + file);
            }
            return null;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

