/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.services.OnOffSwitch;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;

public abstract class ConfigurableAgentService
implements MuleAgentService,
Startable,
Stoppable {
    private OnOffSwitch enabledSwitch;
    @Configurable(method="isEnabledByDefault")
    protected boolean enabled;

    protected abstract void doStart() throws MuleException;

    protected abstract void doStop() throws MuleException;

    @PostConfigure
    public void createSwitchService() {
        if (this.enabledSwitch == null) {
            this.enabledSwitch = new OnOffSwitch(this.enabled, (OnOffSwitch.OnOffSwitchEnabler)new AgentServiceEnabler(), (OnOffSwitch.OnOffSwitchDisabler)new AgentServiceDisabler());
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    public final void start() throws MuleException {
        if (this.enabledSwitch.isEnabled()) {
            this.doStart();
        }
    }

    public final void stop() throws MuleException {
        if (this.enabledSwitch.isEnabled()) {
            this.doStop();
        }
    }

    private class AgentServiceDisabler
    implements OnOffSwitch.OnOffSwitchDisabler {
        private AgentServiceDisabler() {
        }

        public void disable() throws AgentEnableOperationException {
            try {
                ConfigurableAgentService.this.stop();
            }
            catch (MuleException e) {
                throw new AgentEnableOperationException("Could not stop " + ConfigurableAgentService.this.getClass(), (Exception)((Object)e));
            }
        }
    }

    private class AgentServiceEnabler
    implements OnOffSwitch.OnOffSwitchEnabler {
        private AgentServiceEnabler() {
        }

        public void enable() throws AgentEnableOperationException {
            try {
                ConfigurableAgentService.this.doStart();
            }
            catch (MuleException e) {
                throw new AgentEnableOperationException("Could not start " + ConfigurableAgentService.this.getClass(), (Exception)((Object)e));
            }
        }
    }
}

