/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring.loaders;

import com.mulesoft.agent.services.monitoring.JmxTools;
import com.mulesoft.agent.services.monitoring.loaders.MonitorLoader;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.BasicGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemoryMonitorLoader
implements MonitorLoader {
    private static final Logger LOGGER = LogManager.getLogger(MemoryMonitorLoader.class);
    private MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();

    @Override
    public List<Monitor<?>> load() {
        ArrayList gaugeMonitors = new ArrayList();
        try {
            Set<ObjectInstance> objectInstances = this.platformMBeanServer.queryMBeans(ObjectName.getInstance("java.lang:type=MemoryPool,*"), null);
            for (ObjectInstance oi : objectInstances) {
                String name;
                ArrayList<Monitor<?>> monitors = this.createMonitors(oi, name = oi.getObjectName().getKeyProperty("name"));
                if (monitors.isEmpty()) continue;
                BasicCompositeMonitor basicCompositeMonitor = new BasicCompositeMonitor(MonitorConfig.builder((String)oi.getObjectName().getCanonicalName()).build(), monitors);
                gaugeMonitors.add((Monitor<?>)basicCompositeMonitor);
            }
        }
        catch (MalformedObjectNameException e) {
            LOGGER.error("Could not load Memory property from the JMX bean server, publishing of memory monitoring is not going to be possible");
        }
        return gaugeMonitors;
    }

    private ArrayList<Monitor<?>> createMonitors(ObjectInstance oi, String name) {
        ArrayList monitors = new ArrayList();
        CollectionUtils.addIgnoreNull(monitors, this.createMonitor(oi, name + ":Used Memory", "used"));
        CollectionUtils.addIgnoreNull(monitors, this.createMonitor(oi, name + ":Max Memory", "max"));
        CollectionUtils.addIgnoreNull(monitors, this.createMonitor(oi, name + ":Init Memory", "init"));
        CollectionUtils.addIgnoreNull(monitors, this.createMonitor(oi, name + ":Committed Memory", "committed"));
        return monitors;
    }

    private BasicGauge<Long> createMonitor(ObjectInstance oi, String message, String attribute) {
        return new BasicGauge(MonitorConfig.builder((String)message).build(), (Callable)this.createMemoryGaugeAction(oi, attribute));
    }

    private MemoryPoolGaugeAction createMemoryGaugeAction(ObjectInstance oi, String attribute) {
        try {
            return new MemoryPoolGaugeAction(this.platformMBeanServer, oi.getObjectName(), attribute);
        }
        catch (Exception e) {
            LOGGER.debug("Could not load JMX Memory property " + attribute + " that attribute is not going to be published by the monitoring service");
            return null;
        }
    }

    private class MemoryPoolGaugeAction
    implements Callable<Long> {
        private ObjectName name;
        private String attribute;
        private MBeanServer platformMBeanServer;

        private MemoryPoolGaugeAction(MBeanServer platformMBeanServer, ObjectName name, String attribute) throws Exception {
            this.platformMBeanServer = platformMBeanServer;
            this.name = name;
            this.attribute = attribute;
            this.loadProperty();
        }

        @Override
        public Long call() throws Exception {
            try {
                CompositeDataSupport cd = this.loadProperty();
                return JmxTools.getLongAttr(cd, this.attribute);
            }
            catch (Exception e) {
                LOGGER.debug("Could not load JMX Memory property " + this.name + " that attribute is not going to be published by the monitoring service");
                return new Long(0L);
            }
        }

        private CompositeDataSupport loadProperty() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
            return (CompositeDataSupport)this.platformMBeanServer.getAttribute(this.name, "Usage");
        }
    }
}

