/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring.loaders;

import com.mulesoft.agent.domain.monitoring.JvmMemoryArgumentsReader;
import com.mulesoft.agent.services.monitoring.loaders.MonitorLoader;
import com.netflix.servo.monitor.BasicGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JvmArgumentsMonitorLoader
implements MonitorLoader {
    private static final Logger LOGGER = LogManager.getLogger(JvmArgumentsMonitorLoader.class);

    @Override
    public List<Monitor<?>> load() {
        LOGGER.debug("Loading JVM Arguments monitors...");
        ArrayList monitors = new ArrayList();
        monitors.add((Monitor<?>)this.createXmxMonitor());
        monitors.add((Monitor<?>)this.createXmsMonitor());
        LOGGER.debug("Loaded {} JVM Arguments monitors: Xmx, Xms", (Object)monitors.size());
        return monitors;
    }

    private BasicGauge<Number> createXmxMonitor() {
        LOGGER.debug("Creating Xmx monitor");
        return new BasicGauge(MonitorConfig.builder((String)"jvm.arguments.xmx").build(), (Callable)new JvmArgumentGaugeAction("Xmx", () -> JvmMemoryArgumentsReader.getXmxValue()));
    }

    private BasicGauge<Number> createXmsMonitor() {
        LOGGER.debug("Creating Xms monitor");
        return new BasicGauge(MonitorConfig.builder((String)"jvm.arguments.xms").build(), (Callable)new JvmArgumentGaugeAction("Xms", () -> JvmMemoryArgumentsReader.getXmsValue()));
    }

    private static class JvmArgumentGaugeAction
    implements Callable<Number> {
        private final String argumentName;
        private final Callable<Number> valueProvider;

        public JvmArgumentGaugeAction(String argumentName, Callable<Number> valueProvider) {
            this.argumentName = argumentName;
            this.valueProvider = valueProvider;
        }

        @Override
        public Number call() throws Exception {
            try {
                Number value = this.valueProvider.call();
                LOGGER.debug("JVM Argument '{}' value: {}", (Object)this.argumentName, (Object)value);
                return value;
            }
            catch (Exception e) {
                LOGGER.error("Error reading JVM argument '{}': {}", (Object)this.argumentName, (Object)e.getMessage(), (Object)e);
                return -1L;
            }
        }
    }
}

