/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring.loaders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mulesoft.agent.domain.monitoring.FlowMetrics;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.services.monitoring.StatisticsSample;
import com.mulesoft.agent.services.monitoring.calculator.AverageResponseTimeCalculator;
import com.mulesoft.agent.services.monitoring.calculator.ErrorCountCalculator;
import com.mulesoft.agent.services.monitoring.calculator.MessageCountCalculator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.deployment.model.api.application.Application;

public class FlowMetricsLoader {
    private static final String MESSAGES = "messageCount";
    private static final String ERROR_COUNT = "errorCount";
    private static final String RESPONSE_TIME = "responseTime";
    private final MessageCountCalculator messageCountCalculator;
    private final ErrorCountCalculator errorCountCalculator;
    private final AverageResponseTimeCalculator averageResponseTimeCalculator;
    private final Map<String, StatisticsSample> lastReadByFlowName = Maps.newConcurrentMap();

    public FlowMetricsLoader(MessageCountCalculator messageCountCalculator, ErrorCountCalculator errorCountCalculator, AverageResponseTimeCalculator averageResponseTimeCalculator) {
        this.messageCountCalculator = messageCountCalculator;
        this.errorCountCalculator = errorCountCalculator;
        this.averageResponseTimeCalculator = averageResponseTimeCalculator;
    }

    public Map<String, FlowMetrics> loadMetrics(Application application, long now) {
        HashMap result = Maps.newHashMap();
        if (application == null || application.getRegistry() == null) {
            return result;
        }
        Collection flowConstructs = application.getRegistry().lookupAllByType(FlowConstruct.class);
        for (FlowConstruct construct : flowConstructs) {
            String flowName = construct.getName();
            FlowConstructStatistics statistics = construct.getStatistics();
            StatisticsSample lastRead = this.lastReadByFlowName.get(this.getFlowKey(application, flowName));
            StatisticsSample currentRead = new StatisticsSample(flowName, statistics);
            long sampleMessageCount = this.messageCountCalculator.calculate(currentRead, lastRead);
            long sampleErrorCount = this.errorCountCalculator.calculate(currentRead, lastRead);
            long sampleAvgResponseTime = this.averageResponseTimeCalculator.calculate(currentRead, lastRead);
            Metric messageCount = new Metric(now, MESSAGES, (Number)sampleMessageCount);
            Metric errorCount = new Metric(now, ERROR_COUNT, (Number)sampleErrorCount);
            Metric avgResponseTime = new Metric(now, RESPONSE_TIME, (Number)sampleAvgResponseTime);
            FlowMetrics flowMetrics = new FlowMetrics(flowName, (List)Lists.newArrayList((Object[])new Metric[]{messageCount, errorCount, avgResponseTime}));
            result.put(flowName, flowMetrics);
            this.lastReadByFlowName.put(this.getFlowKey(application, flowName), currentRead);
        }
        return result;
    }

    private String getFlowKey(Application application, String flowName) {
        return String.format("%s-%s", application.getArtifactName(), flowName);
    }
}

