/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring.loaders;

import com.mulesoft.agent.domain.monitoring.JMXBean;
import com.mulesoft.agent.domain.monitoring.JMXBeanNotAvailableException;
import com.mulesoft.agent.services.monitoring.JmxTools;
import com.mulesoft.agent.services.monitoring.loaders.MonitorLoader;
import com.netflix.servo.monitor.BasicGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationBasedBeansLoader
implements MonitorLoader {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationBasedBeansLoader.class);
    private MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private JMXBean[] beans;

    public ConfigurationBasedBeansLoader(JMXBean[] beans) {
        this.beans = beans == null ? new JMXBean[]{} : beans;
    }

    @Override
    public List<Monitor<?>> load() {
        ArrayList gaugeMonitors = new ArrayList();
        for (JMXBean bean : this.beans) {
            String beanQueryPattern = bean.getBeanQueryPattern();
            try {
                if (beanQueryPattern == null) continue;
                BasicGauge<Number> monitor = this.createMonitor(ObjectName.getInstance(beanQueryPattern), beanQueryPattern + ":" + bean.getMonitorMessage(), bean.getAttribute());
                gaugeMonitors.add((Monitor<?>)monitor);
            }
            catch (JMXBeanNotAvailableException | MalformedObjectNameException e) {
                LOGGER.debug("Could not load property {}: {} from the JMX bean server, publishing of this attribute is not going to be possible", (Object)beanQueryPattern, (Object)bean.getMonitorMessage(), (Object)e);
            }
        }
        return gaugeMonitors;
    }

    private BasicGauge<Number> createMonitor(ObjectName objectName, String message, String attribute) {
        return new BasicGauge(MonitorConfig.builder((String)message).build(), (Callable)this.createJMXGaugeAction(objectName, attribute));
    }

    private ConfigurationBasedGaugeAction createJMXGaugeAction(ObjectName objectName, String attribute) {
        ConfigurationBasedGaugeAction configurationBasedGaugeAction = new ConfigurationBasedGaugeAction(this.platformMBeanServer, objectName, attribute);
        if (!configurationBasedGaugeAction.isAvailable()) {
            throw new JMXBeanNotAvailableException("Could not load JMX property " + attribute + ", that attribute is not going to be published by the monitoring service");
        }
        return configurationBasedGaugeAction;
    }

    private class ConfigurationBasedGaugeAction
    implements Callable<Number> {
        private ObjectName name;
        private String attribute;
        private MBeanServer platformMBeanServer;

        private ConfigurationBasedGaugeAction(MBeanServer platformMBeanServer, ObjectName name, String attribute) {
            this.platformMBeanServer = platformMBeanServer;
            this.name = name;
            this.attribute = attribute;
        }

        @Override
        public Number call() throws Exception {
            try {
                return this.loadProperty();
            }
            catch (Exception e) {
                LOGGER.debug("Could not load JMX property " + this.name + ", that attribute is not going to be published by the monitoring service");
                return null;
            }
        }

        boolean isAvailable() {
            try {
                this.loadProperty();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private Number loadProperty() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
            String[] chainAttributes = this.attribute.split("\\.");
            int length = chainAttributes.length;
            CompositeData cd = null;
            for (int i = 0; i < length - 1; ++i) {
                cd = (CompositeData)this.platformMBeanServer.getAttribute(this.name, chainAttributes[i]);
            }
            if (cd == null) {
                return (Number)this.platformMBeanServer.getAttribute(this.name, this.attribute);
            }
            return JmxTools.getNumberAttr(cd, chainAttributes[length - 1]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConfigurationBasedGaugeAction)) {
                return false;
            }
            ConfigurationBasedGaugeAction that = (ConfigurationBasedGaugeAction)o;
            if (this.attribute != null ? !this.attribute.equals(that.attribute) : that.attribute != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.attribute != null ? this.attribute.hashCode() : 0);
            return result;
        }
    }
}

