/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring.loaders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mulesoft.agent.domain.monitoring.ApplicationMetrics;
import com.mulesoft.agent.domain.monitoring.FlowMetrics;
import com.mulesoft.agent.domain.monitoring.GroupedApplicationsMetrics;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.services.DateService;
import com.mulesoft.agent.services.monitoring.StatisticsSample;
import com.mulesoft.agent.services.monitoring.calculator.AverageResponseTimeCalculator;
import com.mulesoft.agent.services.monitoring.calculator.ErrorCountCalculator;
import com.mulesoft.agent.services.monitoring.calculator.MessageCountCalculator;
import com.mulesoft.agent.services.monitoring.loaders.FlowMetricsLoader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class ApplicationMetricsLoader {
    private static final String MESSAGES = "messageCount";
    private static final String ERROR_COUNT = "errorCount";
    private static final String RESPONSE_TIME = "responseTime";
    private final DeploymentService deploymentService;
    private final FlowMetricsLoader flowMetricsLoader;
    private final MessageCountCalculator messageCountCalculator;
    private final ErrorCountCalculator errorCountCalculator;
    private final AverageResponseTimeCalculator averageResponseTimeCalculator;
    private final DateService dateService;
    private final Map<String, StatisticsSample> lastReadByApplicationName = Maps.newConcurrentMap();

    public ApplicationMetricsLoader(DeploymentService deploymentService, DateService dateService) {
        this.deploymentService = deploymentService;
        this.messageCountCalculator = new MessageCountCalculator();
        this.errorCountCalculator = new ErrorCountCalculator();
        this.averageResponseTimeCalculator = new AverageResponseTimeCalculator(this.messageCountCalculator);
        this.flowMetricsLoader = new FlowMetricsLoader(this.messageCountCalculator, this.errorCountCalculator, this.averageResponseTimeCalculator);
        this.dateService = dateService;
    }

    public GroupedApplicationsMetrics loadMetrics() {
        LinkedList metrics = Lists.newLinkedList();
        long now = this.dateService.getDate().getTime();
        List applications = this.deploymentService.getApplications();
        if (applications == null) {
            return new GroupedApplicationsMetrics((Collection)metrics);
        }
        for (Application application : applications) {
            Optional allStatisticsOptional;
            if (application == null || application.getRegistry() == null || !(allStatisticsOptional = application.getRegistry().lookupByName("_muleStatistics")).isPresent() || ((AllStatistics)allStatisticsOptional.get()).getApplicationStatistics() == null) continue;
            String applicationName = application.getArtifactName();
            FlowConstructStatistics statistics = ((AllStatistics)allStatisticsOptional.get()).getApplicationStatistics();
            StatisticsSample lastRead = this.lastReadByApplicationName.get(applicationName);
            StatisticsSample currentRead = new StatisticsSample(applicationName, statistics);
            long sampleMessageCount = this.messageCountCalculator.calculate(currentRead, lastRead);
            long sampleErrorCount = this.errorCountCalculator.calculate(currentRead, lastRead);
            long sampleAvgResponseTime = this.averageResponseTimeCalculator.calculate(currentRead, lastRead);
            Metric messageCount = new Metric(now, MESSAGES, (Number)sampleMessageCount);
            Metric errorCount = new Metric(now, ERROR_COUNT, (Number)sampleErrorCount);
            Metric avgResponseTime = new Metric(now, RESPONSE_TIME, (Number)sampleAvgResponseTime);
            Map<String, FlowMetrics> flowMetrics = this.flowMetricsLoader.loadMetrics(application, now);
            ApplicationMetrics applicationMetrics = new ApplicationMetrics(applicationName, (List)Lists.newArrayList((Object[])new Metric[]{messageCount, errorCount, avgResponseTime}), flowMetrics);
            metrics.add(applicationMetrics);
            this.lastReadByApplicationName.put(currentRead.getName(), currentRead);
        }
        return new GroupedApplicationsMetrics((Collection)metrics);
    }
}

