/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring.calculator;

import com.mulesoft.agent.services.monitoring.StatisticsSample;
import com.mulesoft.agent.services.monitoring.calculator.MessageCountCalculator;

public class AverageResponseTimeCalculator {
    private final MessageCountCalculator messageCountCalculator;

    public AverageResponseTimeCalculator(MessageCountCalculator messageCountCalculator) {
        this.messageCountCalculator = messageCountCalculator;
    }

    public long calculate(StatisticsSample currentRead, StatisticsSample lastRead) {
        if (lastRead == null) {
            return currentRead.getAvgResponseTime();
        }
        long sampleMessageCount = this.messageCountCalculator.calculate(currentRead, lastRead);
        if (sampleMessageCount == 0L) {
            return 0L;
        }
        double actualResult = (double)(currentRead.getAccumulatedResponseTime() - lastRead.getAccumulatedResponseTime()) / (double)sampleMessageCount;
        return Math.round(actualResult);
    }
}

