/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring;

import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.DateService;
import com.netflix.servo.publish.MetricObserver;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitoringPublisherObserver
implements MetricObserver {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Set<InternalMessageHandler<ArrayList<Metric>>> metricHandlers;
    private DateService dateService;

    public MonitoringPublisherObserver(DateService dateService, Set<InternalMessageHandler<ArrayList<Metric>>> metricHandlers) {
        this.dateService = dateService;
        this.metricHandlers = metricHandlers;
    }

    public void update(List<com.netflix.servo.Metric> metrics) {
        ArrayList<Metric> muleMetrics = new ArrayList<Metric>();
        for (com.netflix.servo.Metric metric : metrics) {
            Date date = this.dateService.getDate(new Date(metric.getTimestamp()));
            String metricName = metric.getConfig().getName();
            Number metricValue = metric.getNumberValue();
            muleMetrics.add(new Metric(date.getTime(), metricName, metricValue));
        }
        for (InternalMessageHandler internalMessageHandler : this.metricHandlers) {
            if (!internalMessageHandler.isEnabled()) continue;
            this.executor.execute(() -> {
                try {
                    handler.handle((Object)muleMetrics);
                }
                catch (Throwable t) {
                    LOGGER.info("There was an error pushing the metrics. Error: '{}'.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)t));
                    LOGGER.debug("Metrics that couldn't be pushed: '{}'.", (Object)muleMetrics, (Object)t);
                }
            });
        }
    }

    public String getName() {
        return "Mule agent JXM publisher observer";
    }
}

