/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.domain.monitoring.JMXBean;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.domain.monitoring.SupportedJMXBean;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.DateService;
import com.mulesoft.agent.services.MonitoringService;
import com.mulesoft.agent.services.monitoring.MonitoringPublisherObserver;
import com.mulesoft.agent.services.monitoring.loaders.ConfigurationBasedBeansLoader;
import com.mulesoft.agent.services.monitoring.loaders.JvmArgumentsMonitorLoader;
import com.mulesoft.agent.services.monitoring.loaders.MemoryMonitorLoader;
import com.mulesoft.agent.services.monitoring.loaders.MonitorLoader;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.publish.BasicMetricFilter;
import com.netflix.servo.publish.CounterToRateMetricTransform;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.MonitorRegistryMetricPoller;
import com.netflix.servo.publish.PollRunnable;
import com.netflix.servo.publish.PollScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;

@Named(value="mule.agent.jmx.publisher.service")
@Singleton
public class JMXPublisherService
extends ConfigurableAgentService
implements MonitoringService,
Initialisable {
    @Inject
    private DateService dateService;
    @Configurable(type=Type.DYNAMIC, value="60", description="Frequency used to publish information, by default 60 Seconds")
    private Integer frequency;
    @Configurable(type=Type.DYNAMIC, value="SECONDS", description="Time unit for the frequency, by default Seconds")
    private TimeUnit frequencyTimeUnit;
    @Configurable(type=Type.DYNAMIC, method="defaultBeans", value="[]", description="JMX bean that need to be tracked, empty by default")
    private JMXBean[] beans;
    @Inject
    private Set<InternalMessageHandler<ArrayList<Metric>>> metricHandlers;
    private List<Monitor<?>> gaugeMonitors = new ArrayList();
    private MonitorRegistry monitorRegistry = DefaultMonitorRegistry.getInstance();
    private PollScheduler scheduler;
    private List<MonitorLoader> monitorLoaders;

    public JMXBean[] defaultBeans() {
        SupportedJMXBean[] supportedBeans = SupportedJMXBean.values();
        JMXBean[] beans = new JMXBean[supportedBeans.length];
        for (int i = 0; i < supportedBeans.length; ++i) {
            beans[i] = supportedBeans[i].getJMXBean();
        }
        return beans;
    }

    @PostConfigure
    public void loadMonitors() {
        this.monitorLoaders = new ArrayList<MonitorLoader>();
        this.monitorLoaders.add(new MemoryMonitorLoader());
        this.monitorLoaders.add(new ConfigurationBasedBeansLoader(this.beans));
        this.monitorLoaders.add(new JvmArgumentsMonitorLoader());
    }

    public void initialise() throws InitialisationException {
        for (MonitorLoader monitorLoader : this.monitorLoaders) {
            List<Monitor<?>> monitors = monitorLoader.load();
            this.gaugeMonitors.addAll(monitors);
        }
        this.scheduler = PollScheduler.getInstance();
    }

    public void doStart() throws MuleException {
        for (Monitor<?> monitor : this.gaugeMonitors) {
            this.monitorRegistry.register(monitor);
        }
        if (!this.scheduler.isStarted()) {
            this.scheduler.start();
        }
        CounterToRateMetricTransform transform = new CounterToRateMetricTransform((MetricObserver)new MonitoringPublisherObserver(this.dateService, this.metricHandlers), (long)this.frequency.intValue(), this.frequencyTimeUnit);
        PollRunnable task = new PollRunnable((MetricPoller)new MonitorRegistryMetricPoller(), BasicMetricFilter.MATCH_ALL, new MetricObserver[]{transform});
        this.scheduler.addPoller(task, (long)this.frequency.intValue(), this.frequencyTimeUnit);
    }

    public void doStop() throws MuleException {
        if (this.scheduler.isStarted()) {
            this.scheduler.stop();
        }
        for (Monitor<?> monitor : this.gaugeMonitors) {
            DefaultMonitorRegistry.getInstance().unregister(monitor);
        }
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.metricHandlers);
    }

    public JMXBean[] getTrackedBeans() {
        return this.beans;
    }

    public void addTrackedBeans(JMXBean[] newBeans) throws IllegalArgumentException {
        ConfigurationBasedBeansLoader monitorLoader = new ConfigurationBasedBeansLoader(newBeans);
        List<Monitor<?>> newMonitors = monitorLoader.load();
        for (int i = 0; i < newBeans.length; ++i) {
            if (!ArrayUtils.contains((Object[])this.beans, (Object)newBeans[i])) continue;
            throw new IllegalArgumentException("Bean is already registered.");
        }
        this.beans = (JMXBean[])ArrayUtils.addAll((Object[])this.beans, (Object[])newBeans);
        this.gaugeMonitors.addAll(newMonitors);
        for (Monitor<?> monitor : newMonitors) {
            this.monitorRegistry.register(monitor);
        }
    }

    public void removeTrackedBeans(JMXBean[] beansToRemove) throws NoSuchElementException {
        int i;
        ConfigurationBasedBeansLoader monitorLoader = new ConfigurationBasedBeansLoader(beansToRemove);
        List<Monitor<?>> monitorsToRemove = monitorLoader.load();
        for (i = 0; i < beansToRemove.length; ++i) {
            if (ArrayUtils.contains((Object[])this.beans, (Object)beansToRemove[i])) continue;
            throw new NoSuchElementException("Bean is not registered.");
        }
        for (i = 0; i < beansToRemove.length; ++i) {
            this.beans = (JMXBean[])ArrayUtils.removeElement((Object[])this.beans, (Object)beansToRemove[i]);
        }
        this.gaugeMonitors.removeAll(monitorsToRemove);
        for (Monitor<?> monitor : monitorsToRemove) {
            this.monitorRegistry.unregister(monitor);
        }
    }
}

