/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.domain.monitoring.GroupedApplicationsMetrics;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ApplicationMetricService;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.DateService;
import com.mulesoft.agent.services.monitoring.ApplicationMetricPublisher;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.application.metrics.publisher.service")
@Singleton
public class ApplicationMonitoringPublisherService
extends ConfigurableAgentService
implements ApplicationMetricService,
DeploymentServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(ApplicationMonitoringPublisherService.class);
    @Inject
    private Set<InternalMessageHandler<GroupedApplicationsMetrics>> metricHandlers;
    @Inject
    private DateService dateService;
    private ApplicationMetricPublisher publisher;
    private ScheduledExecutorService executor;
    private DeploymentService deploymentService;
    private AgentApplicationDeploymentListener deploymentApplicationListener = new AgentApplicationDeploymentListener();
    @Configurable(type=Type.DYNAMIC, value="60", description="Frequency used to publish information, by default 60 seconds")
    Integer pollingFrequency;
    @Configurable(type=Type.DYNAMIC, value="SECONDS", description="Time unit for the frequency, by default seconds")
    TimeUnit frequencyTimeUnit;

    public ApplicationMonitoringPublisherService() {
    }

    public ApplicationMonitoringPublisherService(Set<InternalMessageHandler<GroupedApplicationsMetrics>> metricHandlers, DeploymentService deploymentService, Integer pollingFrequency, TimeUnit frequencyTimeUnit, DateService dateService) {
        this(metricHandlers, deploymentService, pollingFrequency, frequencyTimeUnit, new ApplicationMetricPublisher(metricHandlers, deploymentService, dateService));
    }

    public ApplicationMonitoringPublisherService(Set<InternalMessageHandler<GroupedApplicationsMetrics>> metricHandlers, DeploymentService deploymentService, Integer pollingFrequency, TimeUnit frequencyTimeUnit, ApplicationMetricPublisher publisher) {
        this.metricHandlers = metricHandlers;
        this.deploymentService = deploymentService;
        this.publisher = publisher;
        this.pollingFrequency = pollingFrequency;
        this.frequencyTimeUnit = frequencyTimeUnit;
    }

    protected void doStart() throws MuleException {
        if (this.deploymentService == null) {
            LOGGER.error("Couldn't start the 'mule.agent.application.metrics.publisher.service' since the DeploymentService is null.");
            return;
        }
        this.deploymentService.addDeploymentListener((DeploymentListener)this.deploymentApplicationListener);
        if (this.publisher == null) {
            this.publisher = new ApplicationMetricPublisher(this.metricHandlers, this.deploymentService, this.dateService);
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(this.publisher, 0L, this.pollingFrequency.intValue(), this.frequencyTimeUnit);
    }

    protected void doStop() throws MuleException {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.metricHandlers);
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private class AgentApplicationDeploymentListener
    implements DeploymentListener {
        private AgentApplicationDeploymentListener() {
        }

        public void onArtifactInitialised(String artifactName, Registry registry) {
            registry.lookupByName("_muleStatistics").ifPresent(allStatistics -> allStatistics.setEnabled(true));
        }
    }
}

