/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.monitoring;

import com.mulesoft.agent.domain.monitoring.GroupedApplicationsMetrics;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.DateService;
import com.mulesoft.agent.services.monitoring.loaders.ApplicationMetricsLoader;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class ApplicationMetricPublisher
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(ApplicationMetricPublisher.class);
    private final Collection<InternalMessageHandler<GroupedApplicationsMetrics>> handlers;
    private final ApplicationMetricsLoader loader;

    public ApplicationMetricPublisher(Collection<InternalMessageHandler<GroupedApplicationsMetrics>> handlers, DeploymentService deploymentService, DateService dateService) {
        this(handlers, new ApplicationMetricsLoader(deploymentService, dateService));
    }

    public ApplicationMetricPublisher(Collection<InternalMessageHandler<GroupedApplicationsMetrics>> handlers, ApplicationMetricsLoader loader) {
        this.handlers = handlers;
        this.loader = loader;
    }

    @Override
    public void run() {
        GroupedApplicationsMetrics metrics = this.loader.loadMetrics();
        this.send(metrics);
    }

    private void send(GroupedApplicationsMetrics metrics) {
        for (InternalMessageHandler<GroupedApplicationsMetrics> handler : this.handlers) {
            if (!handler.isEnabled()) continue;
            try {
                handler.handle((Object)metrics);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Could not publish metrics to %s, cause: %s", handler.getClass().getSimpleName(), e.getMessage()));
                LOGGER.debug("Exception: ", (Throwable)e);
            }
        }
    }
}

