/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.exporter.internal.IncubatingExporterBuilderUtil;
import io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class OtlpDeclarativeConfigUtil {
    public static String getStructuredConfigOtlpProtocol(DeclarativeConfigProperties config) {
        return config.getString("protocol", "http/protobuf");
    }

    public static void configureOtlpExporterBuilder(String dataType, DeclarativeConfigProperties config, Consumer<String> setEndpoint, BiConsumer<String, String> addHeader, Consumer<String> setCompression, Consumer<Duration> setTimeout, Consumer<byte[]> setTrustedCertificates, BiConsumer<byte[], byte[]> setClientTls, Consumer<RetryPolicy> setRetryPolicy, Consumer<MemoryMode> setMemoryMode, boolean isHttpProtobuf) {
        Integer timeoutMs;
        String compression;
        List headers;
        String headerList;
        URL endpoint = OtlpConfigUtil.validateEndpoint(config.getString("endpoint"), isHttpProtobuf);
        if (endpoint != null) {
            setEndpoint.accept(endpoint.toString());
        }
        if ((headerList = config.getString("headers_list")) != null) {
            DefaultConfigProperties headersListConfig = DefaultConfigProperties.createFromMap(Collections.singletonMap("otel.exporter.otlp.headers", headerList));
            OtlpConfigUtil.configureOtlpHeaders((ConfigProperties)headersListConfig, dataType, addHeader);
        }
        if ((headers = config.getStructuredList("headers")) != null) {
            headers.forEach(header -> {
                String name = header.getString("name");
                String value = header.getString("value");
                if (name != null && value != null) {
                    addHeader.accept(name, value);
                }
            });
        }
        if ((compression = config.getString("compression")) != null) {
            setCompression.accept(compression);
        }
        if ((timeoutMs = config.getInt("timeout")) != null) {
            setTimeout.accept(Duration.ofMillis(timeoutMs.intValue()));
        }
        String certificatePath = config.getString("certificate_file");
        String clientKeyPath = config.getString("client_key_file");
        String clientKeyChainPath = config.getString("client_certificate_file");
        if (clientKeyPath != null && clientKeyChainPath == null) {
            throw new ConfigurationException("client_key_file provided without client_certificate_file - both client_key_file and client_certificate_file must be set");
        }
        if (clientKeyPath == null && clientKeyChainPath != null) {
            throw new ConfigurationException("client_certificate_file provided without client_key_file - both client_key_file and client_certificate_file must be set");
        }
        byte[] certificateBytes = OtlpConfigUtil.readFileBytes(certificatePath);
        if (certificateBytes != null) {
            setTrustedCertificates.accept(certificateBytes);
        }
        byte[] clientKeyBytes = OtlpConfigUtil.readFileBytes(clientKeyPath);
        byte[] clientKeyChainBytes = OtlpConfigUtil.readFileBytes(clientKeyChainPath);
        if (clientKeyBytes != null && clientKeyChainBytes != null) {
            setClientTls.accept(clientKeyBytes, clientKeyChainBytes);
        }
        IncubatingExporterBuilderUtil.configureExporterMemoryMode((DeclarativeConfigProperties)config, setMemoryMode);
    }

    private OtlpDeclarativeConfigUtil() {
    }
}

