/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.Cluster;
import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.CustomDiscoveryEndpoints;
import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.HttpMethod;
import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.MuleHttpClient;
import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.ObjectMapperFactory;
import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.RestServiceProperties;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;

public class MuleRuntimeDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private final String baseUrl;
    private final String applicationScope;
    private final String discoveryType;
    private final ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
    private final MuleHttpClient muleHttpClient;
    private final DiscoveryNode discoveryNode;

    public MuleRuntimeDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties, MuleHttpClient muleHttpClient) {
        super(logger, properties);
        this.discoveryNode = discoveryNode;
        this.baseUrl = (String)((Object)this.getOrNull(RestServiceProperties.DISCOVERY_URL));
        this.applicationScope = (String)((Object)this.getOrNull(RestServiceProperties.CLUSTER_ID));
        this.discoveryType = (String)((Object)this.getOrNull(RestServiceProperties.DISCOVERY_MECHANISM));
        this.muleHttpClient = muleHttpClient;
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        List customDiscoveryEndpoints;
        if (this.baseUrl == null) {
            return new ArrayList<DiscoveryNode>();
        }
        String body = this.muleHttpClient.request(String.format("%s/%s", this.baseUrl, this.applicationScope), HttpMethod.GET, null).getJsonBody();
        try {
            customDiscoveryEndpoints = (List)this.objectMapper.readValue(body, (TypeReference)new TypeReference<List<CustomDiscoveryEndpoints>>(){});
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        ArrayList<DiscoveryNode> discoveryNodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : customDiscoveryEndpoints) {
            discoveryNodes.add(this.mapNode(node));
        }
        return discoveryNodes;
    }

    private DiscoveryNode mapNode(DiscoveryNode node) {
        try {
            return new SimpleDiscoveryNode(new Address(node.getPrivateAddress().getHost(), node.getPrivateAddress().getPort()));
        }
        catch (UnknownHostException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public void start() {
        if (this.discoveryType.equals("pcf")) {
            Address address = this.discoveryNode.getPrivateAddress();
            String host = address.getHost();
            int port = address.getPort();
            try {
                this.muleHttpClient.request(this.baseUrl, HttpMethod.POST, this.objectMapper.writeValueAsString((Object)new Cluster(this.applicationScope, host, port)));
            }
            catch (JsonProcessingException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public void destroy() {
    }
}

