/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.mule.runtime.core.internal.util.func.CheckedFunction;

public class HazelcastTimeoutUtils {
    private static final long PARTIAL_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);

    private HazelcastTimeoutUtils() {
    }

    public static <T> T executeWithTimeoutIntervals(long timeoutMillis, CheckedFunction<Long, T> closure, Predicate<T> breakCondition) throws InterruptedException {
        Object result = null;
        if (timeoutMillis < PARTIAL_TIMEOUT_MILLIS) {
            result = HazelcastTimeoutUtils.execute(closure, timeoutMillis);
        } else {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + timeoutMillis;
            long remainingMillis = endTime - startTime;
            while (!(remainingMillis <= 0L || result != null && breakCondition.test(result))) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                result = HazelcastTimeoutUtils.execute(closure, remainingMillis > PARTIAL_TIMEOUT_MILLIS ? PARTIAL_TIMEOUT_MILLIS : remainingMillis);
                remainingMillis = endTime - System.currentTimeMillis();
            }
        }
        return result;
    }

    protected static <T> T execute(CheckedFunction<Long, T> closure, long timeout) throws InterruptedException {
        try {
            return (T)closure.apply((Object)timeout);
        }
        catch (Exception e) {
            if (e.getCause() instanceof InterruptedException) {
                throw (InterruptedException)e.getCause();
            }
            throw e;
        }
    }
}

