/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.cluster.InitialMembershipEvent;
import com.hazelcast.cluster.InitialMembershipListener;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.core.HazelcastInstance;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterMemberInfo;
import com.mulesoft.mule.runtime.module.cluster.api.ClusteringTicket;
import com.mulesoft.mule.runtime.module.cluster.api.notification.ClusterMembershipEvent;
import com.mulesoft.mule.runtime.module.cluster.api.notification.ClusterMembershipListener;
import com.mulesoft.mule.runtime.module.cluster.api.notification.PrimaryClusterNodeListener;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClientModeTimeSupplier;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterService;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastObjectStore;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastObjectStoreFactory;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastTimeSupplier;
import com.mulesoft.mule.runtime.module.cluster.internal.boot.ClusterLicenseCheck;
import com.mulesoft.mule.runtime.module.cluster.internal.boot.ClusterSupportAgent;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterConfigExtension;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterSplashScreen;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterStoreProfile;
import com.mulesoft.mule.runtime.module.cluster.internal.lock.HazelcastLockProvider;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.ClusterQueueManager;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.SwitchingClusterQueueManager;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockProvider;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.lock.ServerLockFactory;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.globalconfig.api.cluster.ClusterConfig;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastClusterCoreExtension
implements ClusterCoreExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastClusterCoreExtension.class);
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    private Boolean clusteringLicensed;
    protected HazelcastClusterManager hazelcastManager;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final ClusterConfig clusterConfig = GlobalConfigLoader.getClusterConfig();
    private ClassLoaderRepository classLoaderRepository;
    private ServerLockFactory serverLockFactory;

    public HazelcastClusterCoreExtension() {
    }

    public HazelcastClusterCoreExtension(ClassLoaderRepository classLoaderRepository, ServerLockFactory serverLockFactory) {
        this.classLoaderRepository = classLoaderRepository;
        this.serverLockFactory = serverLockFactory;
    }

    @Inject
    public void setClassLoaderRepository(ClassLoaderRepository classLoaderRepository) {
        this.classLoaderRepository = classLoaderRepository;
    }

    @Inject
    public void setServerLockFactory(ServerLockFactory serverLockFactory) {
        this.serverLockFactory = serverLockFactory;
    }

    public String getName() {
        return "Mule Clustering Core Extension";
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.initialized.get()) {
            return;
        }
        try {
            if (HazelcastClusterManager.isDuplicateHazelCastServerInstanceRequested()) {
                return;
            }
            this.hazelcastManager = this.createHazelcastManager();
            ClusterSplashScreen clusterSplashScreen = new ClusterSplashScreen(this.hazelcastManager == null ? new Properties() : this.hazelcastManager.getClusterConfigProperties());
            if (this.hazelcastManager != null) {
                this.checkClusterEntitlement();
                this.hazelcastManager.initialise();
                if (this.clusterConfig.getLockFactoryConfig().isEnabled()) {
                    this.serverLockFactory.setLockProvider((LockProvider)this.getLockProvider("container"));
                }
            }
            this.initialized.set(true);
            SPLASH_LOGGER.info(clusterSplashScreen.toString());
        }
        catch (MuleException e) {
            try {
                if (this.hazelcastManager != null) {
                    this.hazelcastManager.dispose();
                    this.hazelcastManager = null;
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Exception disposing of HazelcastClusterManager", (Throwable)ex);
            }
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected HazelcastClusterManager createHazelcastManager() throws InitialisationException {
        return HazelcastClusterManager.create(this.classLoaderRepository);
    }

    public void dispose() {
        if (this.hazelcastManager != null) {
            this.hazelcastManager.dispose();
            this.hazelcastManager = null;
        }
        this.initialized.set(false);
    }

    @Override
    public ClusteringTicket getClusteringTicket() {
        Properties clusterProperties = new Properties();
        FileInputStream ticketStream = null;
        try {
            ticketStream = new FileInputStream(HazelcastClusterCoreExtension.getTicketFile());
            clusterProperties.load(ticketStream);
        }
        catch (IOException e) {
            try {
                throw new MuleRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ticketStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ticketStream);
        String id = clusterProperties.getProperty("mule.clusterId");
        int nodeNumber = Integer.parseInt(clusterProperties.getProperty("mule.clusterNodeId"));
        int clusterSize = Integer.parseInt(clusterProperties.getProperty("mule.clusterSize"));
        String nodeIPs = clusterProperties.getProperty("mule.cluster.nodes");
        String networkInterfaces = clusterProperties.getProperty("mule.cluster.networkinterfaces");
        String multicastEnabled = clusterProperties.getProperty("mule.cluster.multicastenabled");
        String tcpInboundPortProperty = clusterProperties.getProperty("mule.cluster.tcpinboundport");
        Integer tcpInboundPort = tcpInboundPortProperty == null ? null : Integer.valueOf(Integer.parseInt(tcpInboundPortProperty));
        return id == null ? null : new ClusteringTicket(id, nodeNumber, clusterSize, nodeIPs, networkInterfaces, Boolean.parseBoolean(multicastEnabled), tcpInboundPort);
    }

    public boolean isClusteringLicensed() {
        if (this.clusteringLicensed == null) {
            try {
                this.checkClusterEntitlement();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.clusteringLicensed;
    }

    @Override
    public void putClusteringTicket(ClusteringTicket ticket) {
        Properties clusterProperties = new Properties();
        clusterProperties.setProperty("mule.clusterId", ticket.getClusterId());
        clusterProperties.setProperty("mule.clusterNodeId", Integer.toString(ticket.getNodeNumber()));
        clusterProperties.setProperty("mule.clusterSize", Integer.toString(ticket.getClusterSize()));
        clusterProperties.setProperty("mule.clusterSchema", "partitioned-sync2backup");
        if (StringUtils.isNotEmpty((CharSequence)ticket.getNodeIPs())) {
            clusterProperties.setProperty("mule.cluster.nodes", ticket.getNodeIPs());
        }
        if (StringUtils.isNotEmpty((CharSequence)ticket.getConfiguredNetworkInterfaces())) {
            clusterProperties.setProperty("mule.cluster.networkinterfaces", ticket.getConfiguredNetworkInterfaces());
        }
        clusterProperties.setProperty("mule.cluster.multicastenabled", String.valueOf(ticket.isMulticastEnabled()));
        if (ticket.getTcpInboundPort() != null) {
            clusterProperties.setProperty("mule.cluster.tcpinboundport", String.valueOf(ticket.getTcpInboundPort()));
        }
        FileOutputStream ticketStream = null;
        try {
            ticketStream = new FileOutputStream(HazelcastClusterCoreExtension.getTicketFile());
            clusterProperties.store(ticketStream, "Mule cluster properties");
        }
        catch (IOException e) {
            try {
                throw new MuleRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ticketStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)ticketStream);
    }

    @Override
    public boolean isClusterEnabled() {
        return this.hazelcastManager != null;
    }

    @Override
    public void removeClusteringTicket() {
        try {
            File ticketFile = HazelcastClusterCoreExtension.getTicketFile();
            if (ticketFile.exists() && !ticketFile.delete()) {
                throw new IOException("Unable to delete " + ticketFile.getPath());
            }
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public String getCurrentClusterId() {
        if (this.hazelcastManager != null) {
            return this.hazelcastManager.getClusterId();
        }
        return null;
    }

    public static File getTicketFile() throws IOException {
        Path executionFolderPath = MuleFoldersUtil.getExecutionFolderPath();
        if (!Files.exists(executionFolderPath, new LinkOption[0])) {
            throw new IOException("Mule base is not set!");
        }
        return executionFolderPath.resolve("mule-cluster.properties").toFile();
    }

    private void checkClusterEntitlement() throws InitialisationException {
        try {
            ClusterLicenseCheck.checkClusterEntitlement();
            this.clusteringLicensed = Boolean.TRUE;
        }
        catch (Exception e) {
            this.clusteringLicensed = Boolean.FALSE;
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public static boolean isClusteringEnabled() throws Exception {
        try {
            ClusterLicenseCheck.checkClusterEntitlement();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void onArtifactCreated(ArtifactType type, String appName, CustomizationService customizationService) {
        if (this.hazelcastManager != null) {
            if (this.clusterConfig.getLockFactoryConfig().isEnabled()) {
                customizationService.interceptDefaultServiceImpl("_muleLockProvider", serviceInterceptor -> serviceInterceptor.overrideServiceImpl((Object)this.getLockProvider(appName)));
            }
            if (this.clusterConfig.getObjectStoreConfig().isEnabled()) {
                HazelcastObjectStoreFactory hazelcastObjectStoreFactory = new HazelcastObjectStoreFactory(this.hazelcastManager);
                this.registerBaseObjectStores(hazelcastObjectStoreFactory, customizationService);
            }
            if (this.clusterConfig.getTimeSupplierConfig().isEnabled()) {
                customizationService.interceptDefaultServiceImpl("_muleTimeSupplier", serviceInterceptor -> serviceInterceptor.overrideServiceImpl((Object)this.getHazelcastTimeSupplier(this.hazelcastManager)));
            }
            if (this.clusterConfig.getQueueManager().isEnabled()) {
                this.registerQueueManager(customizationService);
            }
            if (this.clusterConfig.getClusterService().isEnabled()) {
                customizationService.interceptDefaultServiceImpl("_muleClusterService", serviceInterceptor -> serviceInterceptor.overrideServiceImpl((Object)new HazelcastClusterService(this.hazelcastManager)));
            }
            customizationService.registerCustomServiceImpl("_muleClusterManager", (Object)this.hazelcastManager);
            this.registerAgent(customizationService);
        }
    }

    private HazelcastLockProvider getLockProvider(String appName) {
        return new HazelcastLockProvider(this.hazelcastManager.getClusterId(), this.hazelcastManager.getHazelcastInstance(), appName);
    }

    private TimeSupplier getHazelcastTimeSupplier(HazelcastClusterManager clusterManager) {
        if (clusterManager.isClientModeEnabled()) {
            return new HazelcastClientModeTimeSupplier(this.hazelcastManager);
        }
        return new HazelcastTimeSupplier(this.hazelcastManager.getHazelcastInstance());
    }

    public void onArtifactInitialised(ArtifactType type, String artifactName, Registry registry) {
        MuleContext context = (MuleContext)registry.lookupByName("_muleContext").get();
        ClusterConfigExtension clusterConfig = (ClusterConfigExtension)((Object)context.getConfiguration().getExtension(ClusterConfigExtension.class));
        if (this.hazelcastManager == null) {
            if (clusterConfig != null) {
                LOGGER.warn("Cluster configuration found for the applications. As application is not deployed in a cluster it won't be used.");
            }
            return;
        }
        this.hazelcastManager.getUserContext().put(artifactName, context);
        ClusterStoreProfile clusterStoreProfile = clusterConfig == null ? this.hazelcastManager.getDefaultClusterStoreProfile() : clusterConfig.getClusterStoreProfile();
        this.configureObjectStoreBackups(clusterStoreProfile, artifactName);
    }

    public void onUndeploymentSuccess(ArtifactType type, String artifactName) {
        if (this.hazelcastManager != null) {
            this.hazelcastManager.getUserContext().remove(artifactName);
        }
    }

    private void registerBaseObjectStores(HazelcastObjectStoreFactory hazelcastObjectStoreFactory, CustomizationService customizationService) {
        customizationService.interceptDefaultServiceImpl("_defaultInMemoryObjectStore", serviceInterceptor -> serviceInterceptor.overrideServiceImpl(hazelcastObjectStoreFactory.createDefaultInMemoryObjectStore()));
        customizationService.interceptDefaultServiceImpl("_defaultPersistentObjectStore", serviceInterceptor -> serviceInterceptor.overrideServiceImpl(hazelcastObjectStoreFactory.createDefaultPersistentObjectStore()));
    }

    private void registerAgent(CustomizationService customizationService) {
        ClusterSupportAgent agent = new ClusterSupportAgent();
        customizationService.registerCustomServiceImpl("_muleClusterSupportAgent", (Object)agent);
    }

    private void registerQueueManager(CustomizationService customizationService) {
        ClusterQueueManager clusterQueueManager = new ClusterQueueManager(this.hazelcastManager);
        customizationService.interceptDefaultServiceImpl("_muleQueueManager", serviceInterceptor -> serviceInterceptor.overrideServiceImpl((Object)new SwitchingClusterQueueManager(clusterQueueManager, this.hazelcastManager.getDefaultClusterStoreProfile())));
    }

    private void configureObjectStoreBackups(ClusterStoreProfile clusterStoreProfile, String appName) {
        if (!this.hazelcastManager.isClientModeEnabled()) {
            int numberOfBackups = clusterStoreProfile.getObjectStoreNumberOfBackups();
            this.hazelcastManager.getHazelcastInstance().getConfig().getMapConfig(HazelcastObjectStore.getObjectStorePrefix(appName) + "*").setBackupCount(numberOfBackups);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The client queue number of backups will be ignored. Server configuration will be honoured");
        }
    }

    @Deprecated
    public HazelcastClusterManager getHazelcastManager() {
        return this.hazelcastManager;
    }

    @Override
    public HazelcastClusterManager getClusterManager() {
        return this.hazelcastManager;
    }

    @Override
    public void registerPrimaryNodeListener(PrimaryClusterNodeListener primaryClusterNodeListener) {
        if (!this.isClusterEnabled()) {
            return;
        }
        this.getHazelcastManager().registerPrimaryNodeListener(primaryClusterNodeListener);
    }

    @Override
    public String registerClusterMembershipListener(final ClusterMembershipListener listener) {
        if (!this.isClusterEnabled()) {
            return null;
        }
        return this.getHazelcastManager().getHazelcastInstance().getCluster().addMembershipListener((MembershipListener)new InitialMembershipListener(){

            public void init(InitialMembershipEvent event) {
                Set<ClusterMemberInfo> collectedMembersInfo = event.getMembers().stream().map(m -> HazelcastClusterCoreExtension.this.getClusterMemberInfo(this.resolvePrimaryPollingInstance((Member)m), (Member)m)).collect(Collectors.toSet());
                listener.init(collectedMembersInfo);
            }

            public void memberAdded(MembershipEvent event) {
                listener.memberAdded(new ClusterMembershipEvent(ClusterMembershipEvent.MembershipEventType.MEMBER_ADDED, HazelcastClusterCoreExtension.this.getClusterMemberInfo(this.resolvePrimaryPollingInstance(event.getMember()), event.getMember())));
            }

            public void memberRemoved(MembershipEvent event) {
                listener.memberRemoved(new ClusterMembershipEvent(ClusterMembershipEvent.MembershipEventType.MEMBER_REMOVED, HazelcastClusterCoreExtension.this.getClusterMemberInfo(this.resolvePrimaryPollingInstance(event.getMember()), event.getMember())));
            }

            private boolean resolvePrimaryPollingInstance(Member member) {
                return member.getUuid().equals(HazelcastClusterCoreExtension.this.hazelcastManager.getHazelcastInstance().getCluster().getLocalMember().getUuid());
            }
        }).toString();
    }

    @Override
    public boolean unregisterClusterMembershipListener(String listenerRegistrationId) {
        return this.getHazelcastManager().getHazelcastInstance().getCluster().removeMembershipListener(UUID.fromString(listenerRegistrationId));
    }

    @Override
    public ClusterMemberInfo getClusterMemberInfo() {
        HazelcastInstance hazelcastInstance = this.hazelcastManager.getHazelcastInstance();
        Member clusterLocalMember = hazelcastInstance.getCluster().getLocalMember();
        return this.getClusterMemberInfo(this.hazelcastManager.isPrimaryPollingInstance(), clusterLocalMember);
    }

    public ClusterMemberInfo getClusterMemberInfo(boolean primaryPollingInstance, Member clusterLocalMember) {
        return new ClusterMemberInfo(clusterLocalMember.getUuid().toString(), this.hazelcastManager.isPrimaryPollingInstance(), clusterLocalMember.getSocketAddress().getAddress().getHostAddress(), clusterLocalMember.getSocketAddress().getPort());
    }

    public void setContainerClassLoader(ArtifactClassLoader containerClassLoader) {
    }
}

