/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.api;

import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoInstantiate;

@NoInstantiate
public final class ClusteringTicket {
    private final String clusterId;
    private final int nodeNumber;
    private final int clusterSize;
    private final String nodeIPs;
    private final String configuredNetworkInterfaces;
    private final Integer tcpInboundPort;
    private final boolean multicastEnabled;

    public ClusteringTicket(String clusterId, int nodeNumber, int clusterSize, String nodeIPs, String networkInterfaces, boolean multicastEnabled, Integer tcpInboundPort) {
        if (nodeNumber < 1) {
            throw new IllegalArgumentException("Node number must be greater than 0");
        }
        if (!multicastEnabled && StringUtils.isEmpty((CharSequence)nodeIPs)) {
            throw new IllegalArgumentException("Node IPs must be provided if multicast is disabled");
        }
        this.clusterId = clusterId;
        this.nodeNumber = nodeNumber;
        this.clusterSize = clusterSize;
        this.nodeIPs = nodeIPs;
        this.configuredNetworkInterfaces = networkInterfaces;
        this.multicastEnabled = multicastEnabled;
        this.tcpInboundPort = tcpInboundPort;
    }

    public ClusteringTicket(String clusterId, int nodeNumber, int clusterSize, String nodeIPs, String networkInterfaces, boolean multicastEnabled) {
        this(clusterId, nodeNumber, clusterSize, nodeIPs, networkInterfaces, multicastEnabled, null);
    }

    public ClusteringTicket(String clusterId, int nodeNumber, int clusterSize) {
        this(clusterId, nodeNumber, clusterSize, null, null, true);
    }

    public ClusteringTicket(String clusterId, int nodeNumber, int clusterSize, String nodeIPs) {
        this(clusterId, nodeNumber, clusterSize, nodeIPs, null, true);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public String getNodeIPs() {
        return this.nodeIPs;
    }

    public String getConfiguredNetworkInterfaces() {
        return this.configuredNetworkInterfaces;
    }

    public boolean isMulticastEnabled() {
        return this.multicastEnabled;
    }

    public Integer getTcpInboundPort() {
        return this.tcpInboundPort;
    }
}

