/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability.configuration.anypoint;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.module.observability.configuration.anypoint.DeploymentType;

public class AnypointMetadataConfigurationResolver {
    public static final String ROOT_ORG_ID = "rootOrgId";
    public static final String ENV_ID = "envId";
    public static final String ORG_ID = "orgId";
    private static final String WORKER_ID = "workerId";
    private static final Function<String, String> DEFAULT_ENV_VARIABLE_RETRIEVER = System::getenv;
    private final Function<String, String> envVariableRetriever = DEFAULT_ENV_VARIABLE_RETRIEVER;
    private String runtimeId;
    private String orgId;
    private String masterOrgId;
    private String envId;
    private DeploymentType deploymentType;

    public Map<String, String> resolveAnypointMetadata() {
        String workerId;
        String envId;
        String orgId;
        HashMap<String, String> globalConfiguration = new HashMap<String, String>();
        String masterOrgId = this.getMasterOrgId();
        if (masterOrgId != null) {
            globalConfiguration.put(ROOT_ORG_ID, masterOrgId);
        }
        if ((orgId = this.getOrgId()) != null) {
            globalConfiguration.put(ORG_ID, orgId);
        }
        if ((envId = this.getEnvId()) != null) {
            globalConfiguration.put(ENV_ID, envId);
        }
        if ((workerId = this.obfuscateWorkerId()) != null) {
            globalConfiguration.put(WORKER_ID, workerId);
        }
        return globalConfiguration;
    }

    private String getOrgId() {
        if (this.orgId == null) {
            this.orgId = System.getProperty("csorganization.id");
            if (this.orgId != null) {
                this.deploymentType = DeploymentType.CLOUDHUB;
            } else {
                this.orgId = this.envVariableRetriever.apply("ORG_ID");
                if (this.orgId != null) {
                    this.deploymentType = DeploymentType.RTF;
                }
            }
        }
        return this.orgId;
    }

    private String getMasterOrgId() {
        if (this.masterOrgId == null) {
            this.masterOrgId = System.getProperty("master.organization.id");
            if (this.masterOrgId == null) {
                this.masterOrgId = this.envVariableRetriever.apply("MASTER_ORG_ID");
            }
            if (this.masterOrgId == null) {
                this.masterOrgId = this.envVariableRetriever.apply("ROOT_ORG_ID");
            }
        }
        return this.masterOrgId;
    }

    private String getEnvId() {
        if (this.envId == null) {
            this.envId = System.getProperty("environment.id");
            if (this.envId == null) {
                this.envId = this.envVariableRetriever.apply("ENV_ID");
            }
        }
        return this.envId;
    }

    private DeploymentType getDeploymentType() {
        this.getOrgId();
        return this.deploymentType;
    }

    private String obfuscateWorkerId() {
        String workerId = this.getRuntimeId();
        if (this.getDeploymentType() == DeploymentType.RTF && workerId != null) {
            String appName = this.getRtfAppName();
            if (appName != null && workerId.startsWith(appName)) {
                workerId = workerId.substring(appName.length() + 1);
            } else {
                int pos = workerId.lastIndexOf("-");
                if (pos > 0 && (pos = workerId.lastIndexOf("-", pos - 1)) >= 0) {
                    workerId = workerId.substring(pos + 1);
                }
            }
        }
        return workerId;
    }

    private String getRuntimeId() {
        if (this.runtimeId == null) {
            String rtId = System.getProperty("runtime.id");
            if (rtId != null) {
                this.runtimeId = rtId;
            } else {
                String workerId = System.getProperty("worker.id");
                if (workerId != null) {
                    this.runtimeId = "worker-" + workerId;
                }
            }
            if (this.runtimeId == null) {
                this.runtimeId = this.envVariableRetriever.apply("POD_NAME");
            }
        }
        return this.runtimeId;
    }

    private String getRtfAppName() {
        return this.envVariableRetriever.apply("APP_NAME");
    }
}

