/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public final class UI {
    private static @Nullable FontMetrics fontMetrics;

    public static @Nullable IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = UI.getActiveWindow();
        return window == null ? null : window.getActivePage();
    }

    public static @Nullable IWorkbenchPart getActivePart() {
        IWorkbenchPage page = UI.getActivePage();
        return page == null ? null : page.getActivePart();
    }

    public static @Nullable Shell getActiveShell() {
        IWorkbenchWindow window = UI.getActiveWindow();
        return window == null ? null : window.getShell();
    }

    /*
     * WARNING - void declaration
     */
    public static @Nullable ITextEditor getActiveTextEditor() {
        IWorkbenchPage activePage = UI.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart editorPart = activePage.getActiveEditor();
        IEditorPart iEditorPart = editorPart;
        if (iEditorPart instanceof ITextEditor) {
            void textEditor;
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            ITextEditor cfr_ignored_0 = (ITextEditor)iEditorPart;
            return textEditor;
        }
        IEditorPart iEditorPart2 = editorPart;
        if (iEditorPart2 instanceof MultiPageEditorPart) {
            void multiPageEditorPart;
            Object page;
            MultiPageEditorPart multiPageEditorPart2 = (MultiPageEditorPart)iEditorPart2;
            MultiPageEditorPart cfr_ignored_1 = (MultiPageEditorPart)iEditorPart2;
            Object object = page = multiPageEditorPart.getSelectedPage();
            if (object instanceof ITextEditor) {
                void textEditor;
                ITextEditor iTextEditor = (ITextEditor)object;
                ITextEditor cfr_ignored_2 = (ITextEditor)object;
                return textEditor;
            }
        }
        return null;
    }

    public static @Nullable ITextViewer getActiveTextViewer() {
        ITextEditor editor = UI.getActiveTextEditor();
        if (editor != null) {
            return (ITextViewer)editor.getAdapter(ITextViewer.class);
        }
        return null;
    }

    public static @Nullable IWorkbenchWindow getActiveWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        Display display = Display.getCurrent();
        if (display != null) {
            return display;
        }
        return Display.getDefault();
    }

    public static boolean selectFirstElement(TableViewer viewer) {
        Object firstElement = viewer.getElementAt(0);
        if (firstElement == null) {
            return false;
        }
        viewer.setSelection((ISelection)new StructuredSelection(firstElement), true);
        return true;
    }

    public static ModifyListener debounceModifyListener(final int delay, final ModifyListener listener) {
        return new ModifyListener(){
            private Runnable later = () -> {};

            public void modifyText(@Nullable ModifyEvent e) {
                Display display = UI.getDisplay();
                display.timerExec(-1, this.later);
                this.later = () -> listener.modifyText(e);
                display.timerExec(delay, this.later);
            }
        };
    }

    public static int convertHeightInCharsToPixels(int chars) {
        if (fontMetrics == null) {
            GC gc = new GC((Drawable)UI.getActiveShell());
            try {
                gc.setFont(JFaceResources.getDialogFont());
                fontMetrics = gc.getFontMetrics();
            }
            finally {
                gc.dispose();
            }
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    public static int getTextWidth(String string) {
        GC gc = new GC((Drawable)UI.getActiveShell());
        try {
            gc.setFont(JFaceResources.getDialogFont());
            int n = gc.stringExtent((String)string).x;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private static int getBrightness(int red, int green, int blue) {
        return (int)(0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue);
    }

    public static boolean isDarkColor(RGB color) {
        return UI.getBrightness(color.red, color.green, color.blue) < 128;
    }

    public static boolean isDarkColor(Color color) {
        return UI.getBrightness(color.getRed(), color.getGreen(), color.getBlue()) < 128;
    }

    public static boolean isDarkEclipseTheme() {
        Shell shell = UI.getActiveShell();
        if (shell == null) {
            throw new IllegalStateException("No active shell found!");
        }
        return UI.isDarkColor(shell.getBackground());
    }

    public static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    public static <T> T runSync(Supplier<T> runnable) {
        if (UI.isUIThread()) {
            return runnable.get();
        }
        AtomicReference resultRef = new AtomicReference();
        AtomicReference exRef = new AtomicReference();
        UI.getDisplay().syncExec(() -> {
            try {
                resultRef.set(runnable.get());
            }
            catch (RuntimeException ex) {
                exRef.set(ex);
            }
        });
        @Nullable RuntimeException ex = (RuntimeException)exRef.get();
        if (ex != null) {
            throw ex;
        }
        return (T)resultRef.get();
    }

    private UI() {
    }
}

