/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.ide.application.IDEApplication;

public class Application
extends IDEApplication {
    private static final String SPLASH_INV = "splash_inv.bmp";
    private static final String SPLASH_PROP = "org.eclipse.equinox.launcher.splash.location";
    private static final int SEQUOIA_VERSION = 15;

    public Object start(IApplicationContext appContext) throws Exception {
        if (Util.isMac() && this.isSequoiaOrGreater()) {
            this.flipSplash();
        }
        return super.start(appContext);
    }

    private boolean isSequoiaOrGreater() {
        try {
            String major = System.getProperty("os.version", "").substring(0, 2);
            return Integer.parseInt(major) >= 15;
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            return false;
        }
    }

    private void flipSplash() {
        String splashLoc = System.getProperty(SPLASH_PROP);
        if (splashLoc != null) {
            Path splashPath = Paths.get(splashLoc, new String[0]).getParent().getParent().getParent().getParent().resolve(SPLASH_INV);
            if (!Files.exists(splashPath, new LinkOption[0])) {
                splashPath = Paths.get(splashLoc, new String[0]).getParent().resolve(SPLASH_INV);
            }
            String splashInverted = splashPath.toString();
            System.setProperty(SPLASH_PROP, splashInverted);
        }
    }
}

