/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.xa;

import bitronix.tm.resource.common.AbstractXAStatefulHolder;
import bitronix.tm.utils.Decoder;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.sdk.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleXaConnectionHandlerDecorator
implements ConnectionHandlerAdapter<XATransactionalConnection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleXaConnectionHandlerDecorator.class);
    private ConnectionHandlerAdapter<XATransactionalConnection> connectionHandlerDelegate;
    private AbstractXAStatefulHolder resourceHolder;

    public MuleXaConnectionHandlerDecorator(ConnectionHandlerAdapter<XATransactionalConnection> connectionHandlerDelegate, AbstractXAStatefulHolder resourceHolder) {
        this.connectionHandlerDelegate = connectionHandlerDelegate;
        this.resourceHolder = resourceHolder;
    }

    public XATransactionalConnection getConnection() throws ConnectionException {
        this.ensureAccessible();
        XATransactionalConnection connection = (XATransactionalConnection)this.connectionHandlerDelegate.getConnection();
        LOGGER.trace("{}.getConnection: {}", (Object)this.resourceHolder, (Object)connection);
        return connection;
    }

    public void release() {
        LOGGER.trace("{}.release", (Object)this.resourceHolder);
        if (0 != this.resourceHolder.getState()) {
            this.resourceHolder.setState(1);
        }
    }

    public void invalidate() {
        LOGGER.trace("{}.invalidate", (Object)this.resourceHolder);
        this.resourceHolder.setState(0);
        this.connectionHandlerDelegate.invalidate();
    }

    public ConnectionProvider<XATransactionalConnection> getConnectionProvider() {
        this.ensureAccessible();
        ConnectionProvider connectionProvider = this.connectionHandlerDelegate.getConnectionProvider();
        LOGGER.trace("{}.getConnectionProvider: {}", (Object)this.resourceHolder, (Object)connectionProvider);
        return connectionProvider;
    }

    private void ensureAccessible() {
        if (2 != this.resourceHolder.getState()) {
            throw new IllegalStateException(this.toString() + " is not ACCESSIBLE, it is " + Decoder.decodeXAStatefulHolderState((int)this.resourceHolder.getState()));
        }
    }

    public void close() throws MuleException {
        LOGGER.trace("{}.close", (Object)this.resourceHolder);
        this.resourceHolder.setState(0);
        this.connectionHandlerDelegate.close();
    }
}

