/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.messaging;

import com.mulesoft.mule.runtime.bti.api.messaging.MessagingConnectionConfig;
import com.mulesoft.mule.runtime.bti.internal.messaging.AbstractConnectionFactoryDecorator;
import com.mulesoft.mule.runtime.bti.internal.messaging.BitronixConnectionFactoryWrapper;
import com.mulesoft.mule.runtime.bti.internal.transaction.MuleTransactionManager;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.XAConnectionFactory;
import jakarta.transaction.TransactionManager;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitronixConnectionFactoryDecorator
extends AbstractConnectionFactoryDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitronixConnectionFactoryDecorator.class);

    @Override
    protected ConnectionFactory doDecorate(ConnectionFactory connectionFactory, MessagingConnectionConfig messagingConfig, MuleConfiguration muleConfiguration, TransactionManager txManager) {
        if (!this.isConnectionFactoryWrapper(connectionFactory) && this.isXaConnectionFactory(connectionFactory)) {
            LOGGER.info("No pool defined for XAConnectionFactory in connector {}. A default pool will be created. To customize define a bti:xa-caching-connection-factory element in your config and assign it to the connector.", (Object)messagingConfig.getName());
            BitronixConnectionFactoryWrapper connectionFactoryWrapper = new BitronixConnectionFactoryWrapper();
            connectionFactoryWrapper.setMuleConfiguration(muleConfiguration);
            connectionFactoryWrapper.setTxManager(txManager);
            connectionFactoryWrapper.setConnectionFactory((XAConnectionFactory)connectionFactory);
            connectionFactoryWrapper.setName(messagingConfig.getName());
            connectionFactoryWrapper.setUsername(messagingConfig.getUsername());
            connectionFactoryWrapper.setPassword(messagingConfig.getPassword());
            connectionFactoryWrapper.setMaxIdleTime(messagingConfig.getMaxIdleTime());
            connectionFactoryWrapper.setMinPoolSize(messagingConfig.getMinPoolSize());
            connectionFactoryWrapper.setMaxPoolSize(messagingConfig.getMaxPoolSize());
            return connectionFactoryWrapper;
        }
        if (this.isConnectionFactoryWrapper(connectionFactory)) {
            BitronixConnectionFactoryWrapper connectionFactoryWrapper = (BitronixConnectionFactoryWrapper)connectionFactory;
            connectionFactoryWrapper.setUsername(messagingConfig.getUsername());
            connectionFactoryWrapper.setPassword(messagingConfig.getPassword());
        }
        return connectionFactory;
    }

    @Override
    public boolean appliesTo(ConnectionFactory connectionFactory) {
        return this.appliesTo(connectionFactory, this.getTxManager());
    }

    private boolean appliesTo(ConnectionFactory connectionFactory, TransactionManager txManager) {
        return this.isBitronixTxManager(txManager) && (this.isConnectionFactoryWrapper(connectionFactory) || this.isXaConnectionFactory(connectionFactory));
    }

    private boolean isBitronixTxManager(TransactionManager txManager) {
        return txManager instanceof MuleTransactionManager;
    }
}

