/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.jms;

import bitronix.tm.resource.jms.DualSessionWrapper;
import bitronix.tm.resource.jms.MessageConsumerWrapper;
import com.mulesoft.mule.runtime.bti.internal.jms.BitronixMessageConsumerInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.transaction.xa.XAResource;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.proxy.TargetInvocationHandler;
import org.mule.runtime.core.internal.transaction.XaTransaction;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixSessionInvocationHandler
implements TargetInvocationHandler,
MuleXaObject {
    private static final Logger logger = LoggerFactory.getLogger(BitronixSessionInvocationHandler.class);
    private final DualSessionWrapper sessionWrapper;
    private boolean reuseSession;

    public BitronixSessionInvocationHandler(DualSessionWrapper sessionWrapper) {
        this.sessionWrapper = sessionWrapper;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Invoking {}", (Object)this, (Object)method);
            }
            if (method.getDeclaringClass().equals(MuleXaObject.class)) {
                return method.invoke((Object)this, args);
            }
            if (method.getName().equals("createConsumer")) {
                MessageConsumerWrapper messageConsumerWrapper = (MessageConsumerWrapper)method.invoke((Object)this.sessionWrapper, args);
                return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{MessageConsumer.class}, (InvocationHandler)((Object)new BitronixMessageConsumerInvocationHandler(messageConsumerWrapper)));
            }
            return method.invoke((Object)this.sessionWrapper, args);
        }
        catch (Exception e) {
            throw this.asConnectionException(e);
        }
    }

    private Exception asConnectionException(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (ReconnectionUtils.extractConnectionException((Throwable)t).isPresent()) {
            return new RuntimeException(t);
        }
        return new RuntimeException(new ConnectionException(t));
    }

    public void close() throws Exception {
        this.sessionWrapper.close();
        this.sessionWrapper.getSession().close();
    }

    public void setReuseObject(boolean reuseObject) {
        this.reuseSession = reuseObject;
    }

    public boolean isReuseObject() {
        return this.reuseSession;
    }

    public boolean enlist() throws TransactionException {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        XAResource xaResource = this.sessionWrapper.getXAResource();
        if (xaResource == null) {
            try {
                this.sessionWrapper.getSession();
            }
            catch (JMSException e) {
                throw new TransactionException((Throwable)e);
            }
        }
        return ((XaTransaction)tx).enlistResource(this.sessionWrapper.getXAResource());
    }

    public boolean delist() throws Exception {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        return ((XaTransaction)tx).delistResource(this.sessionWrapper.getXAResource(), 0x4000000);
    }

    public Object getTargetObject() {
        return this.sessionWrapper;
    }
}

