/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.connection;

import com.mulesoft.mule.runtime.bti.internal.connection.AbstractBtiXAConnectionManagementStrategy;
import com.mulesoft.mule.runtime.bti.internal.xa.MuleXAPooledConnectionHandlerResourceProducer;
import com.mulesoft.mule.runtime.bti.internal.xa.connection.MuleXaPooledConnectionSupplier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.runtime.api.alert.AlertingSupport;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategy;
import org.mule.sdk.api.connectivity.TransactionalConnection;
import org.mule.sdk.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BtiXAPooledConnectionManagementStrategy<C extends TransactionalConnection>
extends AbstractBtiXAConnectionManagementStrategy<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BtiXAPooledConnectionManagementStrategy.class);
    private final PoolingProfile xaPoolingProfile;
    private final AtomicBoolean nonXA = new AtomicBoolean(false);
    private final AtomicReference<MuleXAPooledConnectionHandlerResourceProducer> xaPooledResourceProducer = new AtomicReference();

    BtiXAPooledConnectionManagementStrategy(ConnectionManagementStrategy<C> delegateManagementStrategy, ConnectionManagementStrategy<C> fallbackMgmtStrategy, PoolingProfile xaPoolingProfile, ConnectionProvider<C> connectionProvider, MuleConfiguration muleConfiguration, AlertingSupport alertingSupport) {
        super(delegateManagementStrategy, fallbackMgmtStrategy, connectionProvider, muleConfiguration, alertingSupport);
        this.xaPoolingProfile = xaPoolingProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionHandler<C> getConnectionHandler() throws ConnectionException {
        ConnectionHandler connectionHandler = this.getFallbackMgmtStrategy().getConnectionHandler();
        if (this.nonXA.get()) {
            return connectionHandler;
        }
        MuleXAPooledConnectionHandlerResourceProducer producer = this.xaPooledResourceProducer.get();
        if (producer != null) {
            return producer.getConnectionHandler();
        }
        AtomicReference<MuleXAPooledConnectionHandlerResourceProducer> atomicReference = this.xaPooledResourceProducer;
        synchronized (atomicReference) {
            producer = this.xaPooledResourceProducer.get();
            if (producer != null) {
                return producer.getConnectionHandler();
            }
            TransactionalConnection connection = (TransactionalConnection)connectionHandler.getConnection();
            if (connection instanceof XATransactionalConnection) {
                producer = new MuleXAPooledConnectionHandlerResourceProducer();
                producer.setMinPoolSize(this.xaPoolingProfile.getMaxIdle());
                producer.setMaxPoolSize(this.xaPoolingProfile.getMaxActive());
                producer.setMaxIdleTime(this.xaPoolingProfile.getMinEvictionMillis());
                producer.setClassName(MuleXaPooledConnectionSupplier.class.getName());
                producer.setConstructorArgs(new AtomicReference<ConnectionHandler>(connectionHandler), this.getDelegateManagementStrategy());
                this.configureResourceProducer(producer);
                this.xaPooledResourceProducer.set(producer);
                ConnectionHandler<XATransactionalConnection> connectionHandlerAdapter = producer.getConnectionHandler();
                LOGGER.debug("Connection from '{}' IS XA ({}); handler: '{}'", new Object[]{this.getUniqueName(), connection, connectionHandlerAdapter});
                return connectionHandlerAdapter;
            }
            this.nonXA.set(true);
            LOGGER.debug("Connection from '{}' is not XA ({})", (Object)this.getUniqueName(), (Object)connection);
            return connectionHandler;
        }
    }

    @Override
    public void close() throws MuleException {
        MuleXAPooledConnectionHandlerResourceProducer producer = this.xaPooledResourceProducer.get();
        if (producer != null) {
            producer.close();
        }
        super.close();
    }
}

