/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.connection;

import com.mulesoft.mule.runtime.bti.api.util.BitronixConfigurationUtil;
import com.mulesoft.mule.runtime.bti.internal.xa.AbstractMuleXAResourceProducer;
import org.mule.runtime.api.alert.AlertingSupport;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.sdk.api.connectivity.TransactionalConnection;

abstract class AbstractBtiXAConnectionManagementStrategy<C extends TransactionalConnection>
extends ConnectionManagementStrategy<C> {
    private final ConnectionManagementStrategy<C> delegateManagementStrategy;
    private final ConnectionManagementStrategy<C> fallbackMgmtStrategy;
    private final String uniqueName;
    private final AlertingSupport alertingSupport;

    protected AbstractBtiXAConnectionManagementStrategy(ConnectionManagementStrategy<C> delegateManagementStrategy, ConnectionManagementStrategy<C> fallbackMgmtStrategy, ConnectionProvider<C> connectionProvider, MuleConfiguration muleConfiguration, AlertingSupport alertingSupport) {
        super(connectionProvider);
        this.delegateManagementStrategy = delegateManagementStrategy;
        this.fallbackMgmtStrategy = fallbackMgmtStrategy;
        this.uniqueName = this.resolveUniqueName(connectionProvider, muleConfiguration);
        this.alertingSupport = alertingSupport;
    }

    private String resolveUniqueName(ConnectionProvider<C> connectionProvider, MuleConfiguration muleConfiguration) {
        String ownerConfigName = connectionProvider.toString();
        if (connectionProvider instanceof ConnectionProviderWrapper) {
            ConnectionProviderWrapper cpWrapper = (ConnectionProviderWrapper)connectionProvider;
            ownerConfigName = cpWrapper.getOwnerConfigName().orElse(ownerConfigName);
        }
        return BitronixConfigurationUtil.createUniqueIdForServer() + "-" + muleConfiguration.getId() + "-" + ownerConfigName;
    }

    protected void configureResourceProducer(AbstractMuleXAResourceProducer resourceProducer) {
        resourceProducer.setAutomaticEnlistingEnabled(false);
        resourceProducer.setAllowLocalTransactions(true);
        resourceProducer.setUniqueName(this.uniqueName);
        resourceProducer.setAlertingSupport(this.alertingSupport);
        resourceProducer.init();
    }

    public void close() throws MuleException {
        this.getDelegateManagementStrategy().close();
    }

    protected final ConnectionManagementStrategy<C> getDelegateManagementStrategy() {
        return this.delegateManagementStrategy;
    }

    protected final ConnectionManagementStrategy<C> getFallbackMgmtStrategy() {
        return this.fallbackMgmtStrategy;
    }

    protected final String getUniqueName() {
        return this.uniqueName;
    }
}

