/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.wrappers;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ConfigurationLevel;
import com.mulesoft.agent.configuration.RequiresRestart;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.services.administration.wrappers.ComponentWrapper;
import com.mulesoft.agent.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FieldWrapper {
    Field field;

    private FieldWrapper(Field field) {
        this.field = field;
        this.field.setAccessible(true);
    }

    public static FieldWrapper create(Field field) {
        return new FieldWrapper(field);
    }

    public boolean isDynamicApplicationConfiguration() {
        Configurable annotation = this.field.getAnnotation(Configurable.class);
        return annotation != null && Type.DYNAMIC.equals((Object)annotation.type()) && ConfigurationLevel.APPLICATION.equals((Object)annotation.level());
    }

    public boolean isDynamicConfiguration() {
        Configurable annotation = this.field.getAnnotation(Configurable.class);
        return annotation != null && Type.DYNAMIC.equals((Object)annotation.type());
    }

    public String getName() {
        return this.field.getName();
    }

    public void set(ComponentWrapper component, Object newValue) throws IllegalArgumentException, IllegalAccessException {
        this.field.setAccessible(true);
        this.field.set(component.toSwitcher(), newValue);
    }

    public Object get(ComponentWrapper component) throws IllegalArgumentException, IllegalAccessException {
        this.field.setAccessible(true);
        return this.field.get(component.toSwitcher());
    }

    public Field toField() {
        return this.field;
    }

    public boolean hasUpdateMethod() {
        if (!this.hasConfigurableAnnotation()) {
            return false;
        }
        Configurable annotation = this.field.getAnnotation(Configurable.class);
        return !annotation.update().isEmpty();
    }

    public boolean hasDeleteMethod() {
        if (!this.hasConfigurableAnnotation()) {
            return false;
        }
        Configurable annotation = this.field.getAnnotation(Configurable.class);
        return !annotation.delete().isEmpty();
    }

    public boolean hasConfigurableAnnotation() {
        Configurable annotation = this.field.getAnnotation(Configurable.class);
        return annotation != null;
    }

    public boolean hasRequiresRestartAnnotation() {
        RequiresRestart annotation = this.field.getAnnotation(RequiresRestart.class);
        return annotation != null;
    }

    public boolean hasStopMethod() {
        if (!this.hasRequiresRestartAnnotation()) {
            return false;
        }
        RequiresRestart annotation = this.field.getAnnotation(RequiresRestart.class);
        return !annotation.stop().isEmpty();
    }

    public boolean hasStartMethod() {
        if (!this.hasRequiresRestartAnnotation()) {
            return false;
        }
        RequiresRestart annotation = this.field.getAnnotation(RequiresRestart.class);
        return !annotation.start().isEmpty();
    }

    public void invokeUpdateMethod(ComponentWrapper component, Object configuration) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!this.hasUpdateMethod()) {
            return;
        }
        Configurable annotation = this.field.getAnnotation(Configurable.class);
        Method method = ReflectionUtils.findMethod(component.toSwitcher().getClass(), (String)annotation.update(), (Class[])new Class[]{Object.class});
        method.setAccessible(true);
        method.invoke((Object)component.toSwitcher(), configuration);
    }

    public void invokeDeleteMethod(ComponentWrapper component, Object configuration) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!this.hasDeleteMethod()) {
            return;
        }
        Configurable annotation = this.field.getAnnotation(Configurable.class);
        Method method = ReflectionUtils.findMethod(component.toSwitcher().getClass(), (String)annotation.delete(), (Class[])new Class[]{Object.class});
        method.setAccessible(true);
        method.invoke((Object)component.toSwitcher(), configuration);
    }

    public void invokeStopMethod(ComponentWrapper component) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!this.hasStopMethod()) {
            return;
        }
        RequiresRestart annotation = this.field.getAnnotation(RequiresRestart.class);
        Method method = ReflectionUtils.findMethod(component.toSwitcher().getClass(), (String)annotation.stop());
        method.setAccessible(true);
        method.invoke((Object)component.toSwitcher(), new Object[0]);
    }

    public void invokeStartMethod(ComponentWrapper component, Object configuration) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!this.hasStartMethod()) {
            return;
        }
        RequiresRestart annotation = this.field.getAnnotation(RequiresRestart.class);
        Method method = ReflectionUtils.findMethod(component.toSwitcher().getClass(), (String)annotation.start(), (Class[])new Class[]{Object.class});
        method.setAccessible(true);
        method.invoke((Object)component.toSwitcher(), configuration);
    }

    public boolean isStringType() {
        return String.class.equals(this.field.getType());
    }
}

