/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.wrappers;

import com.mulesoft.agent.configuration.NotRestartable;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.services.Switcher;
import com.mulesoft.agent.services.administration.wrappers.FieldWrapper;
import com.mulesoft.agent.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Named;

public class ComponentWrapper {
    private Switcher component;

    private ComponentWrapper(Switcher component) {
        this.component = component;
    }

    public static ComponentWrapper create(Switcher component) {
        return new ComponentWrapper(component);
    }

    public Switcher toSwitcher() {
        return this.component;
    }

    public boolean isEnabled() {
        return this.component.isEnabled();
    }

    public boolean isRestartable() {
        return !this.component.getClass().isAnnotationPresent(NotRestartable.class);
    }

    public void enable(boolean enable) throws AgentEnableOperationException {
        this.component.enable(enable);
    }

    public String getComponentId() {
        if (this.component.getClass().getAnnotation(Named.class) == null) {
            return "";
        }
        return this.component.getClass().getAnnotation(Named.class).value();
    }

    public FieldWrapper findField(String fieldName) throws NoSuchFieldException {
        Field fieldAsObject = ReflectionUtils.findField(this.component.getClass(), (String)fieldName);
        if (fieldAsObject == null) {
            throw new NoSuchFieldException(String.format("Couldn't find any configurable property with the name '%s' for component '%s' ", fieldName, this.getComponentId()));
        }
        return FieldWrapper.create(fieldAsObject);
    }

    public Field findApplicationConfigurationField() throws NoSuchFieldException {
        Optional<Field> result = Arrays.stream(this.component.getClass().getDeclaredFields()).filter(f -> FieldWrapper.create(f).isDynamicApplicationConfiguration()).findFirst();
        if (!result.isPresent()) {
            throw new NoSuchFieldException(String.format("Couldn't find any application configuration property for component '%s' ", this.getComponentId()));
        }
        return result.get();
    }
}

