/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components.serialization;

import com.google.gson.Gson;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import com.mulesoft.agent.exception.InvalidFieldException;
import com.mulesoft.agent.services.administration.components.serialization.AgentSerializationStrategy;
import com.mulesoft.agent.services.administration.components.serialization.ApplicationSerializationStrategy;
import com.mulesoft.agent.services.administration.components.serialization.ComponentSerializationStrategy;
import com.mulesoft.agent.services.administration.wrappers.ComponentWrapper;
import com.mulesoft.agent.services.administration.wrappers.FieldWrapper;

public class ComponentSerializationStrategyBuilder {
    private ComponentWrapper component;
    private FieldWrapper field;
    private MuleAgentDescriptor descriptor;
    private Gson gson;

    private ComponentSerializationStrategyBuilder(ComponentWrapper component, MuleAgentDescriptor descriptor, Gson gson) {
        this.component = component;
        this.descriptor = descriptor;
        this.gson = gson;
    }

    public static ComponentSerializationStrategyBuilder create(ComponentWrapper component, MuleAgentDescriptor descriptor, Gson gson) {
        return new ComponentSerializationStrategyBuilder(component, descriptor, gson);
    }

    public ComponentSerializationStrategyBuilder from(FieldWrapper field) {
        this.field = field;
        return this;
    }

    public ComponentSerializationStrategy build() throws InvalidFieldException {
        boolean allowDynamicApplicationConfiguration = this.field.isDynamicApplicationConfiguration();
        if (allowDynamicApplicationConfiguration) {
            return ApplicationSerializationStrategy.create(this.component, this.field, this.descriptor, this.gson);
        }
        boolean allowDynamicConfiguration = this.field.isDynamicConfiguration();
        if (allowDynamicConfiguration) {
            return AgentSerializationStrategy.create(this.component, this.field, this.descriptor, this.gson);
        }
        throw new InvalidFieldException();
    }
}

