/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components.serialization;

import com.google.gson.Gson;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import com.mulesoft.agent.services.administration.components.serialization.ComponentSerializationStrategy;
import com.mulesoft.agent.services.administration.wrappers.ComponentWrapper;
import com.mulesoft.agent.services.administration.wrappers.FieldWrapper;

public class AgentSerializationStrategy
implements ComponentSerializationStrategy {
    private ComponentWrapper component;
    private FieldWrapper field;
    private MuleAgentDescriptor descriptor;
    private Gson gson;

    private AgentSerializationStrategy(ComponentWrapper component, FieldWrapper field, MuleAgentDescriptor descriptor, Gson gson) {
        this.component = component;
        this.field = field;
        this.descriptor = descriptor;
        this.gson = gson;
    }

    public static AgentSerializationStrategy create(ComponentWrapper component, FieldWrapper field, MuleAgentDescriptor descriptor, Gson gson) {
        return new AgentSerializationStrategy(component, field, descriptor, gson);
    }

    public void replace(Object value) {
        if (value == null) {
            this.descriptor.setFieldValue(this.component.getClass(), this.field.toField(), null);
            return;
        }
        String valueAsString = this.parseToString(value);
        Object valueAsObject = this.descriptor.getStringFieldValue(this.field.toField(), valueAsString);
        if (valueAsObject == null) {
            throw new IllegalArgumentException(String.format("Unable to get field %s", this.field));
        }
        this.descriptor.setFieldValue(this.component.toSwitcher().getClass(), this.field.toField(), valueAsObject);
    }

    private String parseToString(Object value) {
        String valueAsString = value instanceof String ? (String)value : this.gson.toJson(value);
        return valueAsString;
    }
}

