/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components.operations.fields.executors;

import com.google.gson.Gson;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import com.mulesoft.agent.services.administration.components.operations.fields.executors.ComponentFieldExecutor;
import com.mulesoft.agent.services.administration.exception.FieldExecutorException;
import com.mulesoft.agent.services.administration.wrappers.ComponentWrapper;
import com.mulesoft.agent.services.administration.wrappers.FieldWrapper;
import java.lang.reflect.InvocationTargetException;

public class DefaultFieldExecutor
implements ComponentFieldExecutor {
    private ComponentWrapper component;
    private MuleAgentDescriptor descriptor;
    private Gson gson;
    private FieldWrapper field;

    public DefaultFieldExecutor(ComponentWrapper component, FieldWrapper field, MuleAgentDescriptor descriptor, Gson gson) {
        this.component = component;
        this.field = field;
        this.descriptor = descriptor;
        this.gson = gson;
    }

    @Override
    public void setFieldValue(Object value) throws FieldExecutorException {
        try {
            Object newValue = this.field.isStringType() ? this.descriptor.getStringFieldValue(this.field.toField(), value.toString()) : this.descriptor.getStringFieldValue(this.field.toField(), this.gson.toJson(value));
            if (newValue == null) {
                throw new IllegalArgumentException(String.format("Unable to get field %s", this.field.getName()));
            }
            this.field.set(this.component, newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            String message = String.format("Could not modify the field '%s' for component '%s'", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName());
            throw new FieldExecutorException(message, e);
        }
    }

    @Override
    public Object getFieldValue() throws FieldExecutorException {
        try {
            return this.field.get(this.component);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            String message = String.format("Could not get the field value for '%s' in component '%s'", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName());
            throw new FieldExecutorException(message, e);
        }
    }

    @Override
    public boolean invokeUpdateMethodIfNeeded(Object configuration) throws FieldExecutorException {
        try {
            if (this.field.hasUpdateMethod()) {
                this.field.invokeUpdateMethod(this.component, configuration);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            throw new FieldExecutorException(String.format("Illegal access exception when the update method was called for field '%s' in component '%s': %s", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName(), e.getMessage()));
        }
        catch (InvocationTargetException e) {
            throw new FieldExecutorException(String.format("Invocation target exception when the update method was called for field '%s' in component '%s': %s", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName(), e.getMessage()));
        }
    }

    @Override
    public boolean invokeDeleteMethodIfNeeded(Object configuration) throws FieldExecutorException {
        try {
            if (this.field.hasDeleteMethod()) {
                this.field.invokeDeleteMethod(this.component, configuration);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            throw new FieldExecutorException(String.format("Illegal access exception when the delete method was called for field '%s' in component '%s': %s", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName(), e.getMessage()));
        }
        catch (InvocationTargetException e) {
            throw new FieldExecutorException(String.format("Invocation target exception when the delete method was called for field '%s' in component '%s': %s", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName(), e.getMessage()));
        }
    }

    @Override
    public void restartFieldIfNeeded() throws FieldExecutorException {
        if (!this.field.hasRequiresRestartAnnotation()) {
            return;
        }
        if (this.field.hasStopMethod() && this.field.hasStartMethod()) {
            this.invokeStopMethod();
            this.invokeStartMethod(this.getFieldValue());
            return;
        }
        throw new AssertionError((Object)String.format("Field %s must specify how to stop and start the configuration", this.field.getName()));
    }

    private void invokeStopMethod() throws FieldExecutorException {
        try {
            this.field.invokeStopMethod(this.component);
        }
        catch (IllegalAccessException e) {
            throw new FieldExecutorException(String.format("Illegal access exception when the stop method was called for field '%s' in component '%s': %s", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName(), e.getCause()));
        }
        catch (InvocationTargetException e) {
            throw new FieldExecutorException(String.format("Invocation target exception when the stop method was called for field '%s' in component '%s': %s", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName(), e.getCause()));
        }
    }

    private void invokeStartMethod(Object configuration) throws FieldExecutorException {
        try {
            this.field.invokeStartMethod(this.component, configuration);
        }
        catch (IllegalAccessException e) {
            throw new FieldExecutorException(String.format("Illegal access exception when the start method was called for field '%s' in component '%s': %s", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName(), e.getMessage()));
        }
        catch (InvocationTargetException e) {
            throw new FieldExecutorException(String.format("Invocation target exception when the start method was called for field '%s' in component '%s': %s", this.field.getName(), this.component.toSwitcher().getClass().getSimpleName(), e.getMessage()));
        }
    }
}

