/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components.operations.fields;

import com.mulesoft.agent.exception.InvalidFieldException;
import com.mulesoft.agent.services.administration.components.operations.fields.ApplicationDeleteFieldOperation;
import com.mulesoft.agent.services.administration.components.operations.fields.ApplicationReplaceFieldOperation;
import com.mulesoft.agent.services.administration.components.operations.fields.ApplicationUpdateFieldOperation;
import com.mulesoft.agent.services.administration.components.operations.fields.ComponentFieldOperation;
import com.mulesoft.agent.services.administration.components.operations.fields.ComponentFieldOperationRequest;
import com.mulesoft.agent.services.administration.components.operations.fields.DefaultReplaceFieldOperation;
import com.mulesoft.agent.services.administration.components.operations.fields.FieldOperation;
import com.mulesoft.agent.services.administration.wrappers.FieldWrapper;

public class FieldOperationBuilder {
    private FieldOperation fieldOperation;
    private FieldWrapper field;
    private ComponentFieldOperationRequest request;

    private FieldOperationBuilder() {
    }

    public static FieldOperationBuilder create() {
        return new FieldOperationBuilder();
    }

    public FieldOperationBuilder from(FieldOperation fieldOperation, FieldWrapper field, ComponentFieldOperationRequest request) {
        this.fieldOperation = fieldOperation;
        this.field = field;
        this.request = request;
        return this;
    }

    public ComponentFieldOperation build() throws InvalidFieldException {
        switch (this.fieldOperation) {
            case REPLACE: {
                if (this.field.isDynamicApplicationConfiguration()) {
                    return new ApplicationReplaceFieldOperation(this.request);
                }
                if (!this.field.isDynamicConfiguration()) break;
                return new DefaultReplaceFieldOperation(this.request);
            }
            case UPDATE: {
                if (this.field.isDynamicApplicationConfiguration()) {
                    return new ApplicationUpdateFieldOperation(this.request);
                }
                if (this.field.isDynamicConfiguration()) {
                    return new DefaultReplaceFieldOperation(this.request);
                }
            }
            case DELETE: {
                if (!this.field.isDynamicApplicationConfiguration()) break;
                return new ApplicationDeleteFieldOperation(this.request);
            }
        }
        throw new InvalidFieldException();
    }
}

