/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components.operations.fields;

import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.services.administration.components.operations.fields.ApplicationFieldOperation;
import com.mulesoft.agent.services.administration.components.operations.fields.ComponentFieldOperationRequest;
import com.mulesoft.agent.services.administration.exception.FieldExecutorException;
import java.util.Collections;
import java.util.HashSet;

public class ApplicationUpdateFieldOperation
extends ApplicationFieldOperation {
    private boolean isCustomUpdateMethodInvoked = false;

    public ApplicationUpdateFieldOperation(ComponentFieldOperationRequest request) {
        super(request);
    }

    @Override
    public void beforeReplace() throws FieldExecutorException {
        this.isCustomUpdateMethodInvoked = this.getFieldExecutor().invokeUpdateMethodIfNeeded(this.getRequestFieldValue());
    }

    @Override
    public ApplicationConfiguration[] buildFieldValue() throws FieldExecutorException {
        if (this.isCustomUpdateMethodInvoked) {
            return this.getCurrentConfigurations();
        }
        ApplicationConfiguration[] currentConfigurations = this.getCurrentConfigurationsExcludingByTheApplicationNameInTheRequest();
        HashSet updatedConfigurations = new HashSet();
        Collections.addAll(updatedConfigurations, currentConfigurations);
        if (this.getRequestFieldValue() != null && this.getRequestFieldValue().length > 0) {
            Collections.addAll(updatedConfigurations, this.getRequestFieldValue());
        }
        return (ApplicationConfiguration[])updatedConfigurations.stream().toArray(ApplicationConfiguration[]::new);
    }

    protected boolean isCustomUpdateMethodInvoked() {
        return this.isCustomUpdateMethodInvoked;
    }
}

